% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug.pathway.network.R
\name{network.graph}
\alias{network.graph}
\title{Plot Drug and Pathway Interaction Network}
\usage{
network.graph(path.analysis.res = path.analysis.res,
  pathway.FDR.cutoff = 0.1, pathway.label = FALSE, drug.label.size = 1.2,
  path.label.size = 0.8, return.adj.table = TRUE)
}
\arguments{
\item{path.analysis.res}{The pathway analysis results. Output of function pathway.analysis().}

\item{pathway.FDR.cutoff}{The FDR threshold to select significant drug specific pathways and the default is 0.1.}

\item{pathway.label}{True or False specofying if show pathway labels in the graph.}

\item{drug.label.size}{The number indicating the size of drug labels in the graph.}

\item{path.label.size}{The number indicating the size of pathway labels in the graph.}

\item{return.adj.table}{True or False specifying if return the resulted drug-pathway contigency table.
In the returned table, 1's represent that the pathway is up-regulated by the drug; -1's reprensent down-regulation and 0's no-regulation.}
}
\description{
This function allows user to plot the drug-pathway interaction network and returns the drug-pathway interaction contigency table.
}
\examples{

## get the Dr. Insight drug identification results
drug.ident.res = drug.ident(query.data = example.disease, cmap.ref.profiles = example.drug.profiles,
                 repurposing.unit = "treatment", connectivity = "negative")

## load in example pathway data
data("example.pathway")

## Performe pathway analysis (for the drugs that are identified by ident.drug())
path.analysis.res = pathway.analysis(drug.ident.res = drug.ident.res,
                    pathway.list = example.pathway,drug.FDR.cutoff = 0.5)

drug.pathway.network = network.graph(path.analysis.res, pathway.FDR.cutoff = 0.5,
                       return.adj.table = TRUE, pathway.label = TRUE)
}
\keyword{drug}
\keyword{network}
\keyword{pathway}
