% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ADTestStat.R
\name{ADTestStat}
\alias{ADTestStat}
\title{Plots cumulative density for AD test and computes confidence
interval for AD test stat.}
\usage{
ADTestStat(number.trials, sample.size, confidence.interval)
}
\arguments{
\item{number.trials}{Number of trials}

\item{sample.size}{Sample size}

\item{confidence.interval}{Confidence Interval}
}
\value{
Confidence Interval for AD test statistic
}
\description{
Anderson-Darling(AD) test can be used to carry out distribution equality test and is
similar to Kolmogorov-Smirnov test. AD test statistic is defined as:
\deqn{A^2=n\int_{-\infty}^{\infty}\frac{[\hat{F}(x)-F(x)]^2}{F(x)[1-F(x)]}dF(x)}
which is equivalent to
\deqn{=-n-\frac{1}{n}\sum_{i=1}^n(2i-1)[\ln F(X_i)+\ln(1-F(X_{n+1-i}))]}
}
\examples{
# Probability that the VaR model is correct for 3 failures, 100 number
   # observations and  95\% confidence level
   ADTestStat(1000, 100, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Anderson, T.W. and Darling, D.A. Asymptotic Theory of Certain Goodness of
Fit Criteria Based on Stochastic Processes, The Annals of Mathematical
Statistics, 23(2), 1952, p. 193-212.

Kvam, P.H. and Vidakovic, B. Nonparametric Statistics with Applications to
Science and Engineering, Wiley, 2007.
}

