\name{arrays}
\alias{arrays}
\alias{L18}
\alias{L36}
\alias{L54}
\alias{L4.2.3}
\alias{L8.2.4.4.1}
\alias{L9.3.4}
\alias{L12.2.11}
\alias{L12.2.2.6.1}
\alias{L12.2.4.3.1}
\alias{L16.2.8.8.1}
\alias{L16.4.5}
\alias{L18.3.6.6.1}
\alias{L20.2.19}
\alias{L20.2.2.10.1}
\alias{L20.2.8.5.1}
\alias{L24.2.11.4.1.6.1}
\alias{L24.2.12.12.1}
\alias{L24.2.13.3.1.4.1}
\alias{L24.2.20.4.1}
\alias{L25.5.6}
\alias{L27.3.9.9.1}
\alias{L28.2.12.7.1}
\alias{L28.2.2.14.1}
\alias{L28.2.27}
\alias{L32.2.16.16.1}
\alias{L32.4.8.8.1}
\alias{L36.2.1.3.3.6.3}
\alias{L36.2.10.3.1.6.2}
\alias{L36.2.10.3.8.6.1}
\alias{L36.2.13.3.2.6.1}
\alias{L36.2.13.6.2}
\alias{L36.2.16.9.1}
\alias{L36.2.18.3.1.6.1}
\alias{L36.2.2.18.1}
\alias{L36.2.2.3.5.6.2}
\alias{L36.2.20.3.2}
\alias{L36.2.27.3.1}
\alias{L36.2.3.3.2.6.3}
\alias{L36.2.3.3.9.6.1}
\alias{L36.2.35}
\alias{L36.2.4.3.1.6.3}
\alias{L36.2.8.6.3}
\alias{L36.2.9.3.4.6.2}
\alias{L36.3.12.12.1}
\alias{L36.3.7.6.3}
\alias{L40.2.19.4.1.10.1}
\alias{L40.2.20.20.1}
\alias{L40.2.25.4.1.5.1}
\alias{L40.2.36.4.1}
\alias{L44.2.15.11.1}
\alias{L44.2.2.22.1}
\alias{L44.2.43}
\alias{L45.3.9.15.1}
\alias{L48.2.24.24.1}
\alias{L48.2.31.6.1.8.1}
\alias{L48.2.33.3.1.8.1}
\alias{L48.2.40.8.1}
\alias{L48.4.12.12.1}
\alias{L49.7.8}
\alias{L50.5.10.10.1}
\alias{L52.2.16.13.1}
\alias{L52.2.2.26.1}
\alias{L52.2.51}
\alias{L54.3.18.18.1}
\alias{L54.3.20.6.1.9.1}
\alias{L56.2.27.4.1.14.1}
\alias{L56.2.28.28.1}
\alias{L56.2.37.4.1.7.1}
\alias{L56.2.52.4.1}
\alias{L60.2.15.6.1.10.1}
\alias{L60.2.17.15.1}
\alias{L60.2.2.30.1}
\alias{L60.2.21.10.1}
\alias{L60.2.23.5.1}
\alias{L60.2.24.6.1}
\alias{L60.2.30.3.1}
\alias{L60.2.59}
\alias{L63.3.12.21.1}
\alias{L64.2.32.32.1}
\alias{L64.2.5.4.10.8.4}
\alias{L64.2.5.4.17.8.1}
\alias{L64.4.14.8.3}
\alias{L64.4.16.16.1}
\alias{L64.4.7.8.6}
\alias{L64.8.9}
\alias{L68.2.18.17.1}
\alias{L68.2.2.34.1}
\alias{L68.2.67}
\alias{L72.2.10.3.13.4.1.6.3}
\alias{L72.2.10.3.16.6.2.12.1}
\alias{L72.2.10.3.20.4.1.6.2}
\alias{L72.2.11.3.17.4.1.6.2}
\alias{L72.2.11.3.20.6.1.12.1}
\alias{L72.2.12.3.21.4.1.6.1}
\alias{L72.2.14.3.3.4.1.6.6}
\alias{L72.2.15.3.7.4.1.6.5}
\alias{L72.2.17.3.12.4.1.6.3}
\alias{L72.2.18.3.16.4.1.6.2}
\alias{L72.2.19.3.20.4.1.6.1}
\alias{L72.2.27.3.11.6.1.12.1}
\alias{L72.2.27.3.6.6.4}
\alias{L72.2.28.3.2.6.4}
\alias{L72.2.30.3.1.6.4}
\alias{L72.2.31.6.4}
\alias{L72.2.34.3.3.4.1.6.3}
\alias{L72.2.34.3.8.4.1.6.2}
\alias{L72.2.35.3.12.4.1.6.1}
\alias{L72.2.35.3.5.4.1.6.2}
\alias{L72.2.35.4.1.18.1}
\alias{L72.2.36.3.2.4.1.6.3}
\alias{L72.2.36.3.9.4.1.6.1}
\alias{L72.2.36.36.1}
\alias{L72.2.37.3.1.4.1.6.3}
\alias{L72.2.37.3.13.4.1}
\alias{L72.2.41.4.1.6.3}
\alias{L72.2.42.3.4.4.1.6.2}
\alias{L72.2.43.3.1.4.1.6.2}
\alias{L72.2.43.3.8.4.1.6.1}
\alias{L72.2.44.3.12.4.1}
\alias{L72.2.46.3.2.4.1.6.1}
\alias{L72.2.46.4.1.6.2}
\alias{L72.2.49.4.1.9.1}
\alias{L72.2.5.3.3.4.1.6.7}
\alias{L72.2.51.3.1.4.1.6.1}
\alias{L72.2.53.3.2.4.1}
\alias{L72.2.6.3.3.6.6.12.1}
\alias{L72.2.6.3.7.4.1.6.6}
\alias{L72.2.60.3.1.4.1}
\alias{L72.2.68.4.1}
\alias{L72.2.7.3.4.4.1.6.6}
\alias{L72.2.7.3.7.6.5.12.1}
\alias{L72.2.8.3.12.4.1.6.4}
\alias{L72.2.8.3.8.4.1.6.5}
\alias{L72.2.9.3.12.6.3.12.1}
\alias{L72.2.9.3.16.4.1.6.3}
\alias{L72.3.24.24.1}
\alias{L75.5.8.15.1}
\alias{L76.2.19.19.1}
\alias{L76.2.2.38.1}
\alias{L76.2.75}
\alias{L80.2.40.40.1}
\alias{L80.2.51.4.3.20.1}
\alias{L80.2.55.8.1.10.1}
\alias{L80.2.61.5.1.8.1}
\alias{L80.2.72.8.1}
\alias{L80.4.10.20.1}
\alias{L81.3.27.27.1}
\alias{L81.9.10}
\alias{L84.2.14.6.1.14.1}
\alias{L84.2.2.42.1}
\alias{L84.2.20.21.1}
\alias{L84.2.20.3.1.14.1}
\alias{L84.2.22.6.1.7.1}
\alias{L84.2.27.6.1}
\alias{L84.2.28.7.1}
\alias{L84.2.33.3.1}
\alias{L84.2.83}
\alias{L88.2.43.4.1.22.1}
\alias{L88.2.44.44.1}
\alias{L88.2.56.4.1.11.1}
\alias{L88.2.84.4.1}
\alias{L90.3.26.6.1.15.1}
\alias{L90.3.30.30.1}
\alias{L92.2.2.46.1}
\alias{L92.2.21.23.1}
\alias{L92.2.91}
\alias{L96.2.12.4.20.24.1}
\alias{L96.2.17.4.23.6.1}
\alias{L96.2.18.4.22.12.1}
\alias{L96.2.19.3.1.4.23}
\alias{L96.2.26.4.23}
\alias{L96.2.39.3.1.4.14.8.1}
\alias{L96.2.43.4.12.6.1.8.1}
\alias{L96.2.43.4.15.8.1}
\alias{L96.2.44.4.11.8.1.12.1}
\alias{L96.2.48.48.1}
\alias{L96.2.71.6.1.16.1}
\alias{L96.2.73.3.1.16.1}
\alias{L96.2.80.16.1}
\alias{L98.7.14.14.1}
\alias{L99.3.13.33.1}
\alias{L100.2.16.5.3.10.3}
\alias{L100.2.18.5.9.10.1}
\alias{L100.2.2.50.1}
\alias{L100.2.22.25.1}
\alias{L100.2.29.5.5}
\alias{L100.2.34.5.3.10.1}
\alias{L100.2.4.10.4}
\alias{L100.2.40.5.4}
\alias{L100.2.5.5.4.10.3}
\alias{L100.2.51.5.3}
\alias{L100.2.7.5.10.10.1}
\alias{L100.2.99}
\alias{L100.5.20.20.1}
\alias{L100.5.8.10.3}
\alias{L104.2.100.4.1}
\alias{L104.2.51.4.1.26.1}
\alias{L104.2.52.52.1}
\alias{L104.2.65.4.1.13.1}
\alias{L108.2.1.3.33.6.2.18.1}
\alias{L108.2.1.3.35.6.3.9.1}
\alias{L108.2.10.3.31.6.1.18.1}
\alias{L108.2.10.3.33.6.2.9.1}
\alias{L108.2.10.3.40.6.1.9.1}
\alias{L108.2.107}
\alias{L108.2.12.3.29.6.3}
\alias{L108.2.13.3.30.6.1.18.1}
\alias{L108.2.13.6.3}
\alias{L108.2.15.6.1.18.1}
\alias{L108.2.17.3.29.6.2}
\alias{L108.2.18.3.31.18.1}
\alias{L108.2.18.3.33.6.1.9.1}
\alias{L108.2.2.3.35.6.1.18.1}
\alias{L108.2.2.3.37.6.2.9.1}
\alias{L108.2.2.3.42.18.1}
\alias{L108.2.2.54.1}
\alias{L108.2.20.3.34.9.1}
\alias{L108.2.21.3.1.6.2}
\alias{L108.2.22.27.1}
\alias{L108.2.27.3.33.9.1}
\alias{L108.2.3.3.16.6.8}
\alias{L108.2.3.3.32.6.2.18.1}
\alias{L108.2.3.3.34.6.3.9.1}
\alias{L108.2.3.3.39.18.1}
\alias{L108.2.3.3.41.6.1.9.1}
\alias{L108.2.34.3.29.6.1}
\alias{L108.2.4.3.31.6.2.18.1}
\alias{L108.2.4.3.33.6.3.9.1}
\alias{L108.2.40.6.1}
\alias{L108.2.8.3.30.6.2.18.1}
\alias{L108.2.9.3.34.6.1.18.1}
\alias{L108.2.9.3.36.6.2.9.1}
\alias{L108.3.36.36.1}
\alias{L108.3.37.6.2.18.1}
\alias{L108.3.39.6.3.9.1}
\alias{L108.3.4.6.11}
\alias{L108.3.44.9.1.12.1}
\alias{L112.2.104.8.1}
\alias{L112.2.56.56.1}
\alias{L112.2.75.4.3.28.1}
\alias{L112.2.79.8.1.14.1}
\alias{L112.2.89.7.1.8.1}
\alias{L112.4.12.28.1}
\alias{L116.2.115}
\alias{L116.2.2.58.1}
\alias{L116.2.23.29.1}
\alias{L117.3.13.39.1}
\alias{L120.2.116.4.1}
\alias{L120.2.28.10.1.12.1}
\alias{L120.2.30.6.1.20.1}
\alias{L120.2.59.4.1.30.1}
\alias{L120.2.60.60.1}
\alias{L120.2.68.4.1.6.1.10.1}
\alias{L120.2.70.3.1.4.1.10.1}
\alias{L120.2.70.4.1.5.1.6.1}
\alias{L120.2.74.4.1.15.1}
\alias{L120.2.75.4.1.10.1}
\alias{L120.2.75.4.1.6.1}
\alias{L120.2.79.4.1.5.1}
\alias{L120.2.87.3.1.4.1}
\alias{L121.11.12}
\alias{L124.2.123}
\alias{L124.2.2.62.1}
\alias{L124.2.22.31.1}
\alias{L125.5.25.25.1}
\alias{L126.3.20.6.1.21.1}
\alias{L126.3.21.42.1}
\alias{L126.3.23.6.1.7.1}
\alias{L126.3.24.14.1}
\alias{L128.2.3.4.11.8.13}
\alias{L128.2.3.4.18.8.10}
\alias{L128.2.3.4.25.8.7}
\alias{L128.2.4.4.15.8.9.16.1}
\alias{L128.2.4.4.22.8.6.16.1}
\alias{L128.2.4.4.29.8.3.16.1}
\alias{L128.2.4.4.36.16.1}
\alias{L128.2.4.4.8.8.12.16.1}
\alias{L128.2.5.4.10.8.11.16.1}
\alias{L128.2.5.4.17.8.8.16.1}
\alias{L128.2.5.4.24.8.5.16.1}
\alias{L128.2.5.4.31.8.2.16.1}
\alias{L128.2.5.4.8.8.14}
\alias{L128.2.6.4.12.8.10.16.1}
\alias{L128.2.6.4.19.8.7.16.1}
\alias{L128.2.6.4.26.8.4.16.1}
\alias{L128.2.6.4.33.8.1.16.1}
\alias{L128.2.6.4.5.8.13.16.1}
\alias{L128.2.15.8.1}
\alias{L128.2.64.64.1}
\alias{L128.4.32.32.1}
\alias{L128.8.16.16.1}
\alias{L132.2.131}
\alias{L132.2.15.6.1.22.1}
\alias{L132.2.18.3.1.22.1}
\alias{L132.2.18.6.1.11.1}
\alias{L132.2.2.66.1}
\alias{L132.2.22.33.1}
\alias{L132.2.27.11.1}
\alias{L132.2.42.6.1}
\alias{L135.3.27.45.1}
\alias{L135.3.32.9.1.15.1}
\alias{L136.2.132.4.1}
\alias{L136.2.67.4.1.34.1}
\alias{L136.2.68.68.1}
\alias{L136.2.83.4.1.17.1}
\alias{L140.2.139}
\alias{L140.2.17.10.1.14.1}
\alias{L140.2.2.70.1}
\alias{L140.2.21.7.1.10.1}
\alias{L140.2.22.35.1}
\alias{L140.2.25.5.1.14.1}
\alias{L140.2.27.5.1.7.1}
\alias{L140.2.34.14.1}
\alias{L140.2.36.10.1}
\alias{L140.2.38.7.1}
\alias{L144.12.7}
\alias{L144.2.103.8.1.18.1}
\alias{L144.2.111.6.1.24.1}
\alias{L144.2.113.3.1.24.1}
\alias{L144.2.117.8.1.9.1}
\alias{L144.2.136.8.1}
\alias{L144.2.16.3.3.6.6.24.1}
\alias{L144.2.44.3.11.12.2}
\alias{L144.2.72.72.1}
\alias{L144.2.74.3.4.6.6.8.1}
\alias{L144.2.75.3.3.4.1.6.6.12.1}
\alias{L144.2.76.3.12.6.4.8.1}
\alias{L144.2.76.3.7.4.1.6.5.12.1}
\alias{L144.3.48.48.1}
\alias{L144.4.11.12.2}
\alias{L144.4.36.36.1}
\alias{L256.2.19}
\alias{L2048.2.63}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Orthogonal arrays in the package }
\description{
  Orthogonal arrays in the package
}
\usage{
L18
L36
L54
L4.2.3
L8.2.4.4.1
L9.3.4
L12.2.11
L12.2.2.6.1
L12.2.4.3.1
L16.2.8.8.1
L16.4.5
L18.3.6.6.1
L20.2.19
L20.2.2.10.1
L20.2.8.5.1
L24.2.11.4.1.6.1
L24.2.12.12.1
L24.2.13.3.1.4.1
L24.2.20.4.1
L25.5.6
L27.3.9.9.1
L28.2.12.7.1
L28.2.2.14.1
L28.2.27
L32.2.16.16.1
L32.4.8.8.1
L36.2.1.3.3.6.3
L36.2.10.3.1.6.2
L36.2.10.3.8.6.1
L36.2.13.3.2.6.1
L36.2.13.6.2
L36.2.16.9.1
L36.2.18.3.1.6.1
L36.2.2.18.1
L36.2.2.3.5.6.2
L36.2.20.3.2
L36.2.27.3.1
L36.2.3.3.2.6.3
L36.2.3.3.9.6.1
L36.2.35
L36.2.4.3.1.6.3
L36.2.8.6.3
L36.2.9.3.4.6.2
L36.3.12.12.1
L36.3.7.6.3
L40.2.19.4.1.10.1
L40.2.20.20.1
L40.2.25.4.1.5.1
L40.2.36.4.1
L44.2.15.11.1
L44.2.2.22.1
L44.2.43
L45.3.9.15.1
L48.2.24.24.1
L48.2.31.6.1.8.1
L48.2.33.3.1.8.1
L48.2.40.8.1
L48.4.12.12.1
L49.7.8
L50.5.10.10.1
L52.2.16.13.1
L52.2.2.26.1
L52.2.51
L54.3.18.18.1
L54.3.20.6.1.9.1
L56.2.27.4.1.14.1
L56.2.28.28.1
L56.2.37.4.1.7.1
L56.2.52.4.1
L60.2.15.6.1.10.1
L60.2.17.15.1
L60.2.2.30.1
L60.2.21.10.1
L60.2.23.5.1
L60.2.24.6.1
L60.2.30.3.1
L60.2.59
L63.3.12.21.1
L64.2.32.32.1
L64.2.5.4.10.8.4
L64.2.5.4.17.8.1
L64.4.14.8.3
L64.4.16.16.1
L64.4.7.8.6
L64.8.9
L68.2.18.17.1
L68.2.2.34.1
L68.2.67
L72.2.10.3.13.4.1.6.3
L72.2.10.3.16.6.2.12.1
L72.2.10.3.20.4.1.6.2
L72.2.11.3.17.4.1.6.2
L72.2.11.3.20.6.1.12.1
L72.2.12.3.21.4.1.6.1
L72.2.14.3.3.4.1.6.6
L72.2.15.3.7.4.1.6.5
L72.2.17.3.12.4.1.6.3
L72.2.18.3.16.4.1.6.2
L72.2.19.3.20.4.1.6.1
L72.2.27.3.11.6.1.12.1
L72.2.27.3.6.6.4
L72.2.28.3.2.6.4
L72.2.30.3.1.6.4
L72.2.31.6.4
L72.2.34.3.3.4.1.6.3
L72.2.34.3.8.4.1.6.2
L72.2.35.3.12.4.1.6.1
L72.2.35.3.5.4.1.6.2
L72.2.35.4.1.18.1
L72.2.36.3.2.4.1.6.3
L72.2.36.3.9.4.1.6.1
L72.2.36.36.1
L72.2.37.3.1.4.1.6.3
L72.2.37.3.13.4.1
L72.2.41.4.1.6.3
L72.2.42.3.4.4.1.6.2
L72.2.43.3.1.4.1.6.2
L72.2.43.3.8.4.1.6.1
L72.2.44.3.12.4.1
L72.2.46.3.2.4.1.6.1
L72.2.46.4.1.6.2
L72.2.49.4.1.9.1
L72.2.5.3.3.4.1.6.7
L72.2.51.3.1.4.1.6.1
L72.2.53.3.2.4.1
L72.2.6.3.3.6.6.12.1
L72.2.6.3.7.4.1.6.6
L72.2.60.3.1.4.1
L72.2.68.4.1
L72.2.7.3.4.4.1.6.6
L72.2.7.3.7.6.5.12.1
L72.2.8.3.12.4.1.6.4
L72.2.8.3.8.4.1.6.5
L72.2.9.3.12.6.3.12.1
L72.2.9.3.16.4.1.6.3
L72.3.24.24.1
L75.5.8.15.1
L76.2.19.19.1
L76.2.2.38.1
L76.2.75
L80.2.40.40.1
L80.2.51.4.3.20.1
L80.2.55.8.1.10.1
L80.2.61.5.1.8.1
L80.2.72.8.1
L80.4.10.20.1
L81.3.27.27.1
L81.9.10
L84.2.14.6.1.14.1
L84.2.2.42.1
L84.2.20.21.1
L84.2.20.3.1.14.1
L84.2.22.6.1.7.1
L84.2.27.6.1
L84.2.28.7.1
L84.2.33.3.1
L84.2.83
L88.2.43.4.1.22.1
L88.2.44.44.1
L88.2.56.4.1.11.1
L88.2.84.4.1
L90.3.26.6.1.15.1
L90.3.30.30.1
L92.2.2.46.1
L92.2.21.23.1
L92.2.91
L96.2.12.4.20.24.1
L96.2.17.4.23.6.1
L96.2.18.4.22.12.1
L96.2.19.3.1.4.23
L96.2.26.4.23
L96.2.39.3.1.4.14.8.1
L96.2.43.4.12.6.1.8.1
L96.2.43.4.15.8.1
L96.2.44.4.11.8.1.12.1
L96.2.48.48.1
L96.2.71.6.1.16.1
L96.2.73.3.1.16.1
L96.2.80.16.1
L98.7.14.14.1
L99.3.13.33.1
L100.2.16.5.3.10.3
L100.2.18.5.9.10.1
L100.2.2.50.1
L100.2.22.25.1
L100.2.29.5.5
L100.2.34.5.3.10.1
L100.2.4.10.4
L100.2.40.5.4
L100.2.5.5.4.10.3
L100.2.51.5.3
L100.2.7.5.10.10.1
L100.2.99
L100.5.20.20.1
L100.5.8.10.3
L104.2.100.4.1
L104.2.51.4.1.26.1
L104.2.52.52.1
L104.2.65.4.1.13.1
L108.2.1.3.33.6.2.18.1
L108.2.1.3.35.6.3.9.1
L108.2.10.3.31.6.1.18.1
L108.2.10.3.33.6.2.9.1
L108.2.10.3.40.6.1.9.1
L108.2.107
L108.2.12.3.29.6.3
L108.2.13.3.30.6.1.18.1
L108.2.13.6.3
L108.2.15.6.1.18.1
L108.2.17.3.29.6.2
L108.2.18.3.31.18.1
L108.2.18.3.33.6.1.9.1
L108.2.2.3.35.6.1.18.1
L108.2.2.3.37.6.2.9.1
L108.2.2.3.42.18.1
L108.2.2.54.1
L108.2.20.3.34.9.1
L108.2.21.3.1.6.2
L108.2.22.27.1
L108.2.27.3.33.9.1
L108.2.3.3.16.6.8
L108.2.3.3.32.6.2.18.1
L108.2.3.3.34.6.3.9.1
L108.2.3.3.39.18.1
L108.2.3.3.41.6.1.9.1
L108.2.34.3.29.6.1
L108.2.4.3.31.6.2.18.1
L108.2.4.3.33.6.3.9.1
L108.2.40.6.1
L108.2.8.3.30.6.2.18.1
L108.2.9.3.34.6.1.18.1
L108.2.9.3.36.6.2.9.1
L108.3.36.36.1
L108.3.37.6.2.18.1
L108.3.39.6.3.9.1
L108.3.4.6.11
L108.3.44.9.1.12.1
L112.2.104.8.1
L112.2.56.56.1
L112.2.75.4.3.28.1
L112.2.79.8.1.14.1
L112.2.89.7.1.8.1
L112.4.12.28.1
L116.2.115
L116.2.2.58.1
L116.2.23.29.1
L117.3.13.39.1
L120.2.116.4.1
L120.2.28.10.1.12.1
L120.2.30.6.1.20.1
L120.2.59.4.1.30.1
L120.2.60.60.1
L120.2.68.4.1.6.1.10.1
L120.2.70.3.1.4.1.10.1
L120.2.70.4.1.5.1.6.1
L120.2.74.4.1.15.1
L120.2.75.4.1.10.1
L120.2.75.4.1.6.1
L120.2.79.4.1.5.1
L120.2.87.3.1.4.1
L121.11.12
L124.2.123
L124.2.2.62.1
L124.2.22.31.1
L125.5.25.25.1
L126.3.20.6.1.21.1
L126.3.21.42.1
L126.3.23.6.1.7.1
L126.3.24.14.1
L128.2.3.4.11.8.13
L128.2.3.4.18.8.10
L128.2.3.4.25.8.7
L128.2.4.4.15.8.9.16.1
L128.2.4.4.22.8.6.16.1
L128.2.4.4.29.8.3.16.1
L128.2.4.4.36.16.1
L128.2.4.4.8.8.12.16.1
L128.2.5.4.10.8.11.16.1
L128.2.5.4.17.8.8.16.1
L128.2.5.4.24.8.5.16.1
L128.2.5.4.31.8.2.16.1
L128.2.5.4.8.8.14
L128.2.6.4.12.8.10.16.1
L128.2.6.4.19.8.7.16.1
L128.2.6.4.26.8.4.16.1
L128.2.6.4.33.8.1.16.1
L128.2.6.4.5.8.13.16.1
L128.2.15.8.1
L128.2.64.64.1
L128.4.32.32.1
L128.8.16.16.1
L132.2.131
L132.2.15.6.1.22.1
L132.2.18.3.1.22.1
L132.2.18.6.1.11.1
L132.2.2.66.1
L132.2.22.33.1
L132.2.27.11.1
L132.2.42.6.1
L135.3.27.45.1
L135.3.32.9.1.15.1
L136.2.132.4.1
L136.2.67.4.1.34.1
L136.2.68.68.1
L136.2.83.4.1.17.1
L140.2.139
L140.2.17.10.1.14.1
L140.2.2.70.1
L140.2.21.7.1.10.1
L140.2.22.35.1
L140.2.25.5.1.14.1
L140.2.27.5.1.7.1
L140.2.34.14.1
L140.2.36.10.1
L140.2.38.7.1
L144.12.7
L144.2.103.8.1.18.1
L144.2.111.6.1.24.1
L144.2.113.3.1.24.1
L144.2.117.8.1.9.1
L144.2.136.8.1
L144.2.16.3.3.6.6.24.1
L144.2.44.3.11.12.2
L144.2.72.72.1
L144.2.74.3.4.6.6.8.1
L144.2.75.3.3.4.1.6.6.12.1
L144.2.76.3.12.6.4.8.1
L144.2.76.3.7.4.1.6.5.12.1
L144.3.48.48.1
L144.4.11.12.2
L144.4.36.36.1
L256.2.19
L2048.2.63
}
%- maybe also 'usage' for other objects documented here.

\details{
   All arrays are guaranteed to have orthogonal main effects. 
   
   When being fully populated 
   with experimental factors, most of the arrays are guaranteed to work well only 
   under the ASSUMPTION that there are NO INTERACTIONS; known exceptions are noted 
   in the \code{comment} attribute of the array. Exceptions are, for example, arrays 
   \code{L128.2.15.8.1}, \code{L256.2.19} and \code{L2048.2.63}, 
   which have been taken from Mee (2009, chapter 8) and are resolution V in the 
   2-level factors (but are not regular arrays, there is partial aliasing between 
   higher order effects). 
   
   Populating an array with fewer than the maximum number of factors can 
   result in a reasonable design even in the presence of interactions. The degree 
   of confounding can be checked using various functions based on \code{\link{generalized.word.length}}, 
   and some optimization of column allocation is possible 
   with the \code{column} option of function \code{\link{oa.design}}. 
   Such investigations of a designs properties 
   work well for smaller designs but may be resource-wise prohibitive for larger 
   designs / numbers of factors.

   The array names indicate the number of runs and the numbers of factors: 
   The first portion of each array name (starting with L) indicates number of runs, 
   each subsequent pair of numbers indicates a number of levels together with the frequency with which it occurs.
   For example, \code{L18.3.6.6.1} is an 18 run design with six factors with 
   3 levels each and one factor with 6 levels. 
   
   It is possible to obtain an overview about 
   available arrays for a certain purpose by using function \code{\link{show.oas}}, 
   based on the data frame \code{\link{oacat}}, which holds 
   entries for most arrays and their numbers of factors (exceptions: 
   \code{L18}, \code{L36} and \code{L54} are Taguchi arrays explicitly given,
   which are listed in \code{\link{oacat}} in an isomorphic but not identical 
   form ). This data frame additionally holds entries 
   for further attrays that can be constructed from the explicitly available arrays 
   as \dQuote{child arrays}, cf. below. 
   
   The sources for most arrays listed above is Warren Kuhfelds collection of 
   \dQuote{parent} arrays (exceptions: the Taguchi arrays \code{L18}, \code{L36} and \code{L54} 
   and the Mee 2009 resolution V arrays mentioned above). Using a lineage rule 
   given in the data frame \code{\link{oacat}}, many further 
   arrays can be generated as child arrays from these arrays, cf. also Kuhfeld (2009).
   It is also possible to combine arrays with each other in additional ways not 
   implemented in the package so far, using the nesting process described by 
   Warren Kuhfeld under the name \dQuote{expansive replacement} with other designs 
   than those that he proposes. 
}
\value{
   All arrays are matrices of class \code{\link{oa}}, with all colums coded as 
   integers from 1 to the number of levels.
}
\section{Warning}{
   For designs with only 2-level factors, it is usually more wise to 
   use package \pkg{\link[FrF2:FrF2-package]{FrF2}}. Exceptions: The three arrays by 
   Mee (2009; cf. section \dQuote{Details} above) are very useful for 2-level factors. 
   
   Make sure you understand the implications of using an orthogonal main effects 
   array for experimentation. In particular, for some arrays there is a very severe 
   risk of obtaining biased main effect estimates, if there are some interactions between 
   experimental factors. The documentations for \code{\link{generalized.word.length}} and 
   function \code{\link{oa.design}} contain examples that illustrate this remark.
}
\references{ 
  Hedayat, A.S., Sloane, N.J.A. and Stufken, J. (1999) \emph{Orthogonal Arrays: Theory and Applications}, Springer, New York. 
  
  Kuhfeld, W. (2009). Orthogonal arrays. Website courtesy of SAS Institute \url{http://support.sas.com/techsup/technote/ts723.html}.
  
  Mee, R. (2009). \emph{A Comprehensive Guide to Factorial Two-Level Experimentation}. 
    New York: Springer.

}
\author{ Ulrike Groemping }
\note{ This package is currently under intensive development. Substantial changes are to be expected in the near future.}
\seealso{ See also \code{\link{oacat}}, \code{\link{show.oas}}, \code{\link{generalized.word.length}}, 
    \code{\link{oa.design}}, \code{\link[FrF2]{FrF2}}, \code{\link[FrF2]{pb}}}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
% keyword internal is supposed to hide this help file from the index but does not. Why???
\keyword{ array }
\keyword{ design }
\keyword{ internal }
