% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Disequilibrium.R
\name{predict.DE}
\alias{predict.DE}
\title{Predict method for class 'DE'}
\usage{
\method{predict}{DE}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{DE}.}

\item{newdata}{An optional data frame with column names matching the dependent variables specified in
the \code{formula} of the \code{DE} function. If not provided, the \code{data} from the \code{DE} function
will be used.}

\item{...}{Unused}
}
\value{
A data frame is returned.  The columns are:

\describe{

\item{Y_1}{Linear prediction of the outcome variable in equation 1.}

\item{Y_2}{Linear prediction of the outcome variable in equation 2.}

\item{Min(Y_1,Y_2)}{The minimum of \code{Y_1} and \code{Y_2}.}

\item{Prob(Y_2>Y_1)}{The probability that the outcome variable in equation 2 is greater than the outcome
variable in equation 1.  This is the probability that \code{Y_1} is the observed quantity. This probability does not account for estimation uncertainty. Also note that all predictions are unconditional on the observed quantity.}

}
}
\description{
Predict method for class 'DE'
}
\examples{
set.seed(1775)
library(MASS)
beta01 = c(1,1)
beta02 = c(-1,-1)
N = 10000
SigmaEps = diag(2)
SigmaX = diag(2)
MuX = c(0,0)
par0 = c(beta01, beta02, SigmaX[1, 1], SigmaX[1, 2], SigmaX[2, 2])

Xgen = mvrnorm(N,MuX,SigmaX)
X1 = cbind(1,Xgen[,1])
X2 = cbind(1,Xgen[,2])
X = list(X1 = X1,X2 = X2)
eps = mvrnorm(N,c(0,0),SigmaEps)
eps1 = eps[,1]
eps2 = eps[,2]
Y1 = X1 \%*\% beta01 + eps1
Y2 = X2 \%*\% beta02 + eps2
Y = pmin(Y1,Y2)
df = data.frame(Y = Y, X1 = Xgen[,1], X2 = Xgen[,2])

results = DE(formula = Y ~ X1 | X2, data = df)

head(predict(results))

}
