% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aux_fun.R
\name{match.pvals}
\alias{match.pvals}
\title{Matching Raw P-Values with Supports}
\usage{
match.pvals(test.results, pCDFlist, pCDFlist.indices = NULL)
}
\arguments{
\item{test.results}{either a numeric vector with \eqn{p}-values or an R6 object of class \code{\link[DiscreteTests]{DiscreteTestResults}} from package \link[DiscreteTests]{DiscreteTests} for which a discrete FDR procedure is to be performed.}

\item{pCDFlist}{list of the supports of the CDFs of the \eqn{p}-values; each list item must be a numeric vector, which is sorted in increasing order and whose last element equals 1.}

\item{pCDFlist.indices}{list of numeric vectors containing the test indices that indicate to which raw \eqn{p}-value each \strong{unique} support in \code{pCDFlist} belongs; ignored if the lengths of \code{test.results} and \code{pCDFlist} are equal.}
}
\value{
A vector where each raw p-value has been replaced by its nearest neighbor, if
necessary.
}
\description{
Constructs the observed p-values from the raw observed p-values, by rounding
them to their nearest neighbor matching with the supports of their
respective CDFs (as in function \code{p.discrete.adjust()} of package
\code{discreteMTP}, which is no longer available on CRAN).

\strong{Note}: This is an internal function and has to be called directly via
\code{:::}, i.e. \code{DiscreteFDR:::match.pvals()}.
}
\details{
Well computed raw p-values should already belong to their respective CDF
support. So this function is called at the beginning of \code{\link[=discrete.BH]{discrete.BH()}},
\code{\link[=DBH]{DBH()}}, \code{\link[=ADBH]{ADBH()}} and \code{\link[=DBR]{DBR()}}, just in case raw p-values are biased.

For each raw p-value that needs to be rounded, a warning is issued.
}
\seealso{
\code{\link[=discrete.BH]{discrete.BH()}}, \code{\link[=DBR]{DBR()}}
}
\keyword{internal}
