% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{colon_stageBC_chemo_df}
\alias{colon_stageBC_chemo_df}
\title{Chemotherapy for Stage B/C Colon Cancer}
\format{
A data frame with 1858 observations and 16 variables:
\describe{
  \item{id}{Numeric patient identifier}
  \item{study}{Numeric study code}
  \item{rx}{Factor with 3 levels indicating treatment group}
  \item{sex}{Numeric gender code}
  \item{age}{Numeric age in years}
  \item{obstruct}{Numeric obstruction status}
  \item{perfor}{Numeric perforation status}
  \item{adhere}{Numeric adhesion status}
  \item{nodes}{Numeric count of lymph nodes}
  \item{status}{Numeric event status}
  \item{differ}{Numeric differentiation grade}
  \item{extent}{Numeric tumor extent}
  \item{surg}{Numeric surgery code}
  \item{node4}{Numeric node4 status}
  \item{time}{Numeric follow-up time}
  \item{etype}{Numeric event type}
}
}
\source{
Data taken from the \pkg{OncoDataSets} package version 0.1.0.
}
\usage{
data(colon_stageBC_chemo_df)
}
\description{
This dataset, colon_stageBC_chemo_df, is a data frame containing data from one of the first successful
trials of adjuvant chemotherapy for stage B/C colon cancer. The dataset includes 1858 observations
(with two records per patient: one for recurrence and one for death) and 16 clinical variables.
}
\details{
The dataset name has been kept as 'colon_stageBC_chemo_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
