% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_edge_attrs.R
\name{copy_edge_attrs}
\alias{copy_edge_attrs}
\title{Copy an edge attribute column and set the name}
\usage{
copy_edge_attrs(graph, edge_attr_from, edge_attr_to)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge_attr_from}{The name of the edge attribute column from which values
will be copied.}

\item{edge_attr_to}{The name of the new edge attribute column to which the
copied values will be placed.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal edge data frame (edf), copy the contents an
existing edge attribute and create a distinct edge attribute within the edf
with a different attribute name.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 5,
    m = 8,
    set_seed = 23) \%>\%
  set_edge_attrs(
    edge_attr = color,
    values = "green")

# Get the graph's internal
# edf to show which edge
# attributes are available
graph \%>\% get_edge_df()

# Make a copy the `color`
# edge attribute as the
# `color_2` edge attribute
graph <-
  graph \%>\%
  copy_edge_attrs(
    edge_attr_from = color,
    edge_attr_to = color_2)

# Get the graph's internal
# edf to show that the edge
# attribute had been copied
graph \%>\% get_edge_df()

}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_edge}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
