% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_nodes_by_id.R
\name{select_nodes_by_id}
\alias{select_nodes_by_id}
\title{Select nodes in a graph by their ID values}
\usage{
select_nodes_by_id(graph, nodes, set_op = "union")
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{nodes}{A vector of node IDs for the selection of nodes present in the
graph.}

\item{set_op}{The set operation to perform upon consecutive selections of
graph nodes. This can either be as a \code{union} (the default), as an
intersection of selections with \code{intersect}, or, as a \code{difference} on the
previous selection, if it exists.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Select nodes in a graph object of class \code{dgr_graph} by their node ID values.
If nodes have IDs that are monotonically increasing integer values, then
numeric ranges can be used for the selection.
}
\examples{
# Create a node data frame (ndf)
ndf <- create_node_df(n = 10)

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf)

# Select nodes `1` to `5` and show that
# selection of nodes with `get_selection()`
graph \%>\%
  select_nodes_by_id(nodes = 1:5) \%>\%
  get_selection()

}
