% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_graph.R
\name{render_graph}
\alias{render_graph}
\title{Render the graph in various formats}
\usage{
render_graph(graph, layout = NULL, output = NULL, title = NULL,
  width = NULL, height = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{layout}{a string specifying a layout type to
use for node placement in this rendering. Possible
layouts include: \code{nicely}, \code{circle},
\code{tree}, \code{kk}, and \code{fr}.}

\item{output}{a string specifying the output type;
\code{graph} (the default) renders the graph using
the \code{grViz} function and \code{visNetwork}
renders the graph using the \code{visnetwork} function.}

\item{title}{an optional title for a graph when
using \code{output = "graph"}.}

\item{width}{an optional parameter for specifying
the width of the resulting graphic in pixels.}

\item{height}{an optional parameter for specifying
the height of the resulting graphic in pixels.}
}
\description{
Using a \code{dgr_graph} object,
render the graph in the RStudio Viewer.
}
\examples{
\dontrun{
# Render a graph that's a balanced tree
create_graph() \%>\%
  add_balanced_tree(
    k = 2, h = 3) \%>\%
  render_graph()

# Use the `tree` layout for better node
# placement in this hierarchical graph
create_graph() \%>\%
  add_balanced_tree(
    k = 2, h = 3) \%>\%
  render_graph(layout = "tree")

# Plot the same tree graph but don't
# show the node ID values
create_graph() \%>\%
  add_balanced_tree(
    k = 2, h = 3) \%>\%
  set_node_attr_to_display() \%>\%
  render_graph(layout = "tree")

# Create a circle graph with
create_random_graph(
  n = 55, m = 75,
  set_seed = 23) \%>\%
render_graph(layout = "circle")

# Render the graph using the `visNetwork`
# output option
create_graph() \%>\%
  add_balanced_tree(
    k = 2, h = 3) \%>\%
  render_graph(
    output = "visNetwork")
}
}
