% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_global_graph_attrs.R
\name{get_global_graph_attrs}
\alias{get_global_graph_attrs}
\title{Get global graph attributes}
\usage{
get_global_graph_attrs(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame containing global attributes
for the graph.
}
\description{
Get the presently set global attributes
for a graph object of class \code{dgr_graph}.
}
\examples{
# Create a new graph and set some global attributes
graph <-
  create_graph() \%>\%
  set_global_graph_attrs(
    "overlap", "true", "graph")

# View the graph's set of global attributes
# as a data frame
get_global_graph_attrs(graph)
#>      attr value attr_type
#> 1 overlap  true     graph
}

