% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_igraph.R
\name{from_igraph}
\alias{from_igraph}
\title{Convert an igraph graph to a DiagrammeR one}
\usage{
from_igraph(igraph, write_backups = FALSE)
}
\arguments{
\item{igraph}{an igraph graph object.}

\item{write_backups}{an option to write incremental
backups of changing graph states to disk. If
\code{TRUE}, a subdirectory of the working directory
will be used to store \code{RDS} files. The
default value is \code{FALSE} so one has to opt in
to use this functionality.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Convert an igraph graph to a DiagrammeR
graph object.
}
\examples{
# Create a DiagrammeR graph object
dgr_graph_orig <-
  create_random_graph(
    36, 50, set_seed = 1,
    directed = TRUE)

# Convert the DiagrammeR graph to an
# igraph object
ig_graph <- to_igraph(dgr_graph_orig)

# Convert the igraph graph back to a
# DiagrammeR graph
dgr_graph_new <- from_igraph(ig_graph)
}

