% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Loan_amortization.R
\name{Loan_amortization}
\alias{Loan_amortization}
\title{Loan Amortization}
\usage{
Loan_amortization(V0, n, i, i2 = 0, alic = 0, ins = 0, method)
}
\arguments{
\item{V0}{A numeric type value. Loan value.}

\item{n}{A numeric type value. The number of payments.}

\item{i}{A numeric type value or a vector of them. The interest rate of the loan.}

\item{i2}{A numeric type value. The interest rate of the saving account.}

\item{alic}{A numeric type value. Interest tax rate.}

\item{ins}{A numeric type value. The rate of V0 to be paid in each period.}

\item{method}{A string. Amortization method used ("constant_installment","interest_only", "constant_principal", "interest_only_wsavings_account" or "constant_installment_varintrate" ).}
}
\value{
Returns a data.frame object containing Period, Payment, Pure Payment, Intrest, Amortization, Insurance, TAX and Outstanding debt.
}
\description{
Calculates the amortization schedule.
}
\examples{
Loan_amortization(1000,12,0.04,0,0.21,0.01,"constant_installment")
Loan_amortization(12000,15,0.04,0,0.21,0.01,"interest_only")
Loan_amortization(13000,10,0.04,0,0.21,0.01,"constant_principal")
Loan_amortization(15000,20,0.04,0.05,0.21,0.01,"interest_only_wsavings_account")
Loan_amortization(5000,5,0.04,0,0.21,0.01,"constant_installment_varintrate")


}
\keyword{Amortization}
\keyword{Loan}
