% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.box.R
\name{ds.box}
\alias{ds.box}
\title{Boxplot Parameters of a numeric vector}
\usage{
ds.box(x, c = 1.5, c.width = 0.15 , out = TRUE, tojson = FALSE)
}
\arguments{
\item{x}{The input numeric vector}

\item{c}{Determines the length of the "whiskers" plot.
If it is equal to zero or out=F, no outliers will be returned.}

\item{c.width}{The width level is determined 0.15 times the square root of the size of the input vector}

\item{out}{If TRUE the outliers will be computed at the selected "c" level (default is 1.5 times the Interquartile Range).}

\item{tojson}{If TRUE the results are returned in json format}
}
\value{
Returns a list or a json file with the following components:
\itemize{ 
\item lo.whisker The extreme of the lower whisker
\item lo.hinge The lower "hinge"
\item median The median
\item up.hinge The upper "hinge"
\item up.whisker The extreme of the upper whisker
\item box.width The width of the box (default is 0.15 times the 
square root of the size of the vector)
\item lo.out The values of any data points which lie below the extreme of the lower whisker
\item up.out The values of any data points which lie above the extreme of the upper whisker
\item n The non-NA observations of the vector
}
}
\description{
This function calculates the statistical measures needed to visualize the boxplot of a numeric vector.
}
\details{
This function returns a list with the parameters needed to visualize a boxplot.
}
\examples{
# with vector as an input and the default parameters
vec <- as.vector(iris$Sepal.Width)
ds.box(vec)

# with vector as an input and the different parameters
vec <- as.vector(iris$Sepal.Width)
ds.box(vec, c = 3, c.width = 0.20 , out = FALSE, tojson = FALSE)

# OpenBudgets.eu Dataset Example:
amounts <- as.vector(Wuppertal_df$Amount)
ds.box(amounts, c = 1.5, c.width = 0.20, out = TRUE)

}
\seealso{
\code{\link{ds.analysis}}, \code{\link{open_spending.ds}}
}
\author{
Kleanthis Koupidis, Charalampos Bratsas
}
