% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,DDPlot}
\alias{plot,DDPlot,ANY-method}
\alias{plot,DepthCurve}
\alias{plot,DepthCurve,ANY-method}
\alias{plot,DepthCurveList}
\alias{plot,DepthCurveList,ANY-method}
\title{Method for plotting DepthCurve and DDPlot object.}
\usage{
plot(x, y, ...)

\S4method{plot}{DDPlot,ANY}(x)

\S4method{plot}{DepthCurve,ANY}(x)

\S4method{plot}{DepthCurveList,ANY}(x)
}
\arguments{
\item{x}{object that inherits from DepthCurve class (ScaleCurve or AsymmetryCurve), or DDPlot class.}

\item{y}{the y coordinates of points in the plot, \emph{optional}
    if \code{x} is an appropriate structure.}

\item{...}{Arguments to be passed to methods, such as
    \link{graphical parameters} (see \code{\link{par}}).
    Many methods will accept the following arguments:
    \describe{
    \item{\code{type}}{what type of plot should be drawn.  Possible types are
      \itemize{
        \item \code{"p"} for \bold{p}oints,
        \item \code{"l"} for \bold{l}ines,
        \item \code{"b"} for \bold{b}oth,
        \item \code{"c"} for the lines part alone of \code{"b"},
        \item \code{"o"} for both \sQuote{\bold{o}verplotted},
        \item \code{"h"} for \sQuote{\bold{h}istogram} like (or
        \sQuote{high-density}) vertical lines,
        \item \code{"s"} for stair \bold{s}teps,
        \item \code{"S"} for other \bold{s}teps, see \sQuote{Details} below,
        \item \code{"n"} for no plotting.
      }
      All other \code{type}s give a warning or an error; using, e.g.,
      \code{type = "punkte"} being equivalent to \code{type = "p"} for S
      compatibility.  Note that some methods,
      e.g. \code{\link{plot.factor}}, do not accept this.
    }
    \item{\code{main}}{an overall title for the plot: see \code{\link{title}}.}
    \item{\code{sub}}{a sub title for the plot: see \code{\link{title}}.}
    \item{\code{xlab}}{a title for the x axis: see \code{\link{title}}.}
    \item{\code{ylab}}{a title for the y axis: see \code{\link{title}}.}
    \item{\code{asp}}{the \eqn{y/x} aspect ratio,
      see \code{\link{plot.window}}.}
    }
  }
}
\description{
Plot Depth curve
}
\examples{
x = mvrnorm(n = 100, mu = c(0,0), Sigma = 3*diag(2))
sc = scaleCurve(x)
plot(sc)
}

