% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryText.R
\name{summaryText}
\alias{summaryText}
\title{Summary Text}
\usage{
summaryText(x, fmt, ...)
}
\arguments{
\item{x}{an R object}

\item{fmt}{see \code{\link[base]{sprintf}}}

\item{...}{potential parameters}
}
\value{
\code{\link{summaryText}} returns a \code{\link[base]{character}} scalar
}
\description{
Provide the summary text of an R object
}
\examples{
x = rpois(n = 20L, lambda = 2)
x[sample.int(length(x), 3L)] = NA_integer_
summaryText(x)

# factor 
x = state.region
x[2L] = NA_integer_
summaryText(x)

# binary
summaryText(c(TRUE, FALSE, TRUE, NA))
summaryText(c(TRUE, FALSE, TRUE))
summaryText(c(FALSE, FALSE, NA))
summaryText(c(FALSE, FALSE, FALSE))
summaryText(c(NA, NA, NA))


}
