/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Color;
import org.rosuda.deducer.widgets.param.Param;
import org.w3c.dom.Element;

public class ParamColor
extends Param {
    protected Color value;
    protected Color defaultValue;

    public ParamColor() {
        this.name = "";
        this.title = "";
        this.value = null;
        this.defaultValue = null;
        this.view = "org.rosuda.deducer.widgets.param.ParamColorWidget";
    }

    public ParamColor(String string) {
        this.name = string;
        this.title = string;
        this.value = null;
        this.defaultValue = null;
        this.view = "org.rosuda.deducer.widgets.param.ParamColorWidget";
    }

    public ParamColor(String string, String string2) {
        this.name = string;
        this.title = string;
        this.value = Color.decode(string2);
        this.defaultValue = Color.decode(string2);
        this.view = "org.rosuda.deducer.widgets.param.ParamColorWidget";
    }

    public ParamColor(String string, Color color) {
        this.name = string;
        this.title = string;
        this.value = color;
        this.defaultValue = color;
        this.view = "org.rosuda.deducer.widgets.param.ParamColorWidget";
    }

    public ParamColor(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.title = string2;
        this.view = string3;
        this.value = Color.decode(string4);
        this.defaultValue = Color.decode(string5);
    }

    public ParamColor(String string, String string2, String string3, Color color, Color color2) {
        this.name = string;
        this.title = string2;
        this.view = string3;
        this.value = color;
        this.defaultValue = color2;
        this.view = "org.rosuda.deducer.widgets.param.ParamColorWidget";
    }

    public Object clone() {
        Color color;
        ParamColor paramColor = new ParamColor();
        paramColor.setName(this.name);
        paramColor.setTitle(this.title);
        if (this.getValue() != null) {
            color = (Color)this.getValue();
            ((Param)paramColor).setValue(new Color(color.getRGB()));
        }
        if (this.getDefaultValue() != null) {
            color = (Color)this.getDefaultValue();
            ((Param)paramColor).setDefaultValue(new Color(color.getRGB()));
        }
        paramColor.setViewType(this.getViewType());
        paramColor.required = this.required;
        return paramColor;
    }

    public String[] getParamCalls() {
        String[] stringArray;
        if (this.value != null && !this.value.equals(this.defaultValue)) {
            String string = "";
            if (this.getValue().toString().length() > 0) {
                string = "'#" + Integer.toHexString(((Color)this.getValue()).getRGB()).substring(2) + "'";
            }
            stringArray = string.length() > 0 ? new String[]{(this.name != null ? this.name + " = " : "") + string} : new String[]{};
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void setDefaultValue(Object object) {
        if (object instanceof Color || this.value == null) {
            this.defaultValue = (Color)object;
        } else {
            System.out.println("ParamColor: invalid setDefaultValue");
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(Object object) {
        if (object instanceof Color || object == null) {
            this.value = (Color)object;
        } else {
            System.out.println("ParamColor: invalid setValue");
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Element toXML() {
        String string;
        Element element = super.toXML();
        if (this.value != null) {
            string = "#" + Integer.toHexString(((Color)this.getValue()).getRGB()).substring(2);
            element.setAttribute("value", string);
        }
        if (this.defaultValue != null) {
            string = "#" + Integer.toHexString(((Color)this.getDefaultValue()).getRGB()).substring(2);
            element.setAttribute("defaultValue", string);
        }
        element.setAttribute("className", "org.rosuda.deducer.widgets.param.ParamColor");
        return element;
    }

    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.widgets.param.ParamColor")) {
            System.out.println("Error ParamColor: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        super.setFromXML(element);
        if (element.hasAttribute("value")) {
            this.value = Color.decode(element.getAttribute("value"));
        }
        if (element.hasAttribute("defaultValue")) {
            this.defaultValue = Color.decode(element.getAttribute("defaultValue"));
        }
    }

    public boolean hasValidEntry() {
        return this.value != null || this.defaultValue != null;
    }
}

