% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_reveal.R
\name{declare_reveal}
\alias{declare_reveal}
\alias{declare_reveal_handler}
\title{Declare a reveal outcomes step}
\usage{
declare_reveal(..., handler = declare_reveal_handler, label = NULL)

declare_reveal_handler(
  data = NULL,
  outcome_variables = Y,
  assignment_variables = Z,
  attrition_variables = NULL,
  ...
)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}

\item{data}{A data.frame containing columns for assignment and potential outcomes.}

\item{outcome_variables}{The outcome prefix(es) of the potential outcomes.}

\item{assignment_variables}{Unquoted name(s) of the assignment variable(s).}

\item{attrition_variables}{Unquoted name of the attrition variable.}
}
\description{
Potential outcomes declarations indicate what outcomes would obtain for different possible values of assignment variables. 
But realized outcomes need to be "revealed." 
\code{declare_reveal} generates these realized outcomes using information on 
potential outcomes  (for instance generated via \code{declare_potential_outcomes})  and the relevant 
assignment variables (for example created by \code{declare_assignment}). 
Revelation steps are usefully included after declaration of all assignments of conditions required to determine the realized outcome.
If a revelation is not declared, DeclareDesign will try to guess appropriate revelations. Explicit revelation is recommended however.
}
\details{
This function was previously called \code{declare_reveal}. You can still use either one.

\code{declare_reveal} declares how outcomes should be realized.  
A "revelation" uses the random assignment to pluck out the correct potential outcomes (Gerber and Green 2012, Chapter 2).
Revelation requires that every named outcome variable is a function of every named assignment variable within a step. Thus if multiple outcome variables depend on different assignment variables, multiple revelations are needed.
}
\examples{

design <- 
  declare_model(
    N = 100, 
    U = rnorm(N), 
    Y_Z_0 = U, 
    Y_Z_1 = U + rnorm(N, mean = 2, sd = 2)
  ) + 
  declare_assignment(Z = complete_ra(N, m = 50), legacy = FALSE) + 
  declare_measurement(Y = reveal_outcomes(Y ~ Z))

# Declaring multiple assignment variables or multiple outcome variables

design   <- 
  declare_model(
    N = 10,
    potential_outcomes(Y1 ~ Z),
    potential_outcomes(Y2 ~ 1 + 2 * Z),
    potential_outcomes(Y3 ~ 1 - X * Z, conditions = list(X = 0:1, Z = 0:1))
  ) + 
  declare_assignment(Z = complete_ra(N), legacy = FALSE) + 
  declare_assignment(X = complete_ra(N), legacy = FALSE) + 
  declare_measurement(Y1 = reveal_outcomes(Y1 ~ Z), 
                      Y2 = reveal_outcomes(Y2 ~ Z),
                      Y3 = reveal_outcomes(Y3 ~ X + Z))

design <- 
  declare_model(
    N = 100, 
    age = sample(18:95, N, replace = TRUE),
    potential_outcomes(Y ~ .25 * Z + .01 * age * Z),
    potential_outcomes(R ~ rbinom(n = N, size = 1, prob = pnorm(Y_Z_0)))
  ) + 
  declare_assignment(Z = complete_ra(N, m = 25), legacy = FALSE)
  declare_measurement(R = reveal_outcomes(R ~ Z),
                      Y = reveal_outcomes(Y ~ Z),
                      Y = ifelse(R == 1, Y, NA))
}
