% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_reveal.R
\name{reveal_outcomes}
\alias{reveal_outcomes}
\alias{declare_reveal}
\alias{reveal_outcomes_handler}
\title{Declare a reveal outcomes step}
\usage{
reveal_outcomes(..., handler = reveal_outcomes_handler, label = NULL)

declare_reveal(..., handler = reveal_outcomes_handler, label = NULL)

reveal_outcomes_handler(
  data = NULL,
  outcome_variables = Y,
  assignment_variables = Z,
  attrition_variables = NULL,
  ...
)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}

\item{data}{A data.frame containing columns for assignment and potential outcomes.}

\item{outcome_variables}{The outcome prefix(es) of the potential outcomes.}

\item{assignment_variables}{Unquoted name(s) of the assignment variable(s).}

\item{attrition_variables}{Unquoted name of the attrition variable.}
}
\description{
Potential outcomes declarations indicate what outcomes would obtain for different possible values of assignment variables. 
To reveal actual outcomes we combine assignments with potential outcomes. \code{reveal_outcomes} provides information on how this
revelation should be implemented, identifying the relevant assignment variables (for example created by \code{declare_assignment}) and outcome variables. 
Revelation steps are usefully included after declaration of all assignments of conditions required to determine the realized outcome.
If a revelation is not declared DeclareDesign will try to guess appropriate revelations though explicit revelation is recommended.
}
\details{
This function was previously called \code{declare_reveal}. You can still use either one.

\code{reveal_outcomes} declares how outcomes should be realized.  
A "revelation" uses the random assignment to pluck out the correct potential outcomes (Gerber and Green 2012, Chapter 2).
If you create a simple design (with assignment variable Z and outcome variable Y) with the + operator but omit a reveal declaration, DeclareDesign will attempt to insert a revelation  step automatically.
If you have multiple outcomes to reveal or different names for the outcome or assignment variables, use \code{reveal_outcomes} to customize which outcomes are revealed.
Revelation requires that every named outcome variable is a function of every named assignment variable within a step. Thus if multiple outcome variables depend on different assignment variables, multiple revelations are needed.
}
\examples{

my_population <- declare_population(N = 100, noise = rnorm(N))

my_potential_outcomes <- declare_potential_outcomes(
  Y_Z_0 = noise, Y_Z_1 = noise +
  rnorm(N, mean = 2, sd = 2))

my_assignment <- declare_assignment(m = 50)

my_reveal <- reveal_outcomes()

design <- my_population +
  my_potential_outcomes +
  my_assignment +
  my_reveal

design

#  Here the + operator results in the same design being
#  created, because it automatically adds a reveal_outcomes step.

design <- my_population + my_potential_outcomes + my_assignment

# Declaring multiple assignment variables or multiple outcome variables

population   <- declare_population(N = 10)
potentials_1 <- declare_potential_outcomes(Y1 ~ Z)  
potentials_2 <- declare_potential_outcomes(Y2 ~ 1 + 2*Z)  
potentials_3 <- declare_potential_outcomes(Y3 ~ 1 - X*Z, conditions = list(X = 0:1, Z = 0:1))  
assignment_Z <- declare_assignment(assignment_variable = "Z")
assignment_X <- declare_assignment(assignment_variable = "X")
reveal_1     <- reveal_outcomes(outcome_variables = c("Y1", "Y2"), assignment_variables = "Z")
reveal_2     <- reveal_outcomes(outcome_variables = "Y3", assignment_variables = c("X", "Z"))

# Note here that the reveal cannot be done in one step, e.g. by using
# reveal_outcomes(outcome_variables = c("Y1", "Y2", "Y3"),
#   assignment_variables = c("X","Z"))
# The reason is that in each revelation all outcome variables should be a
# function of all assignment variables.

# reveal_outcomes can also be used to declare outcomes that include attrition

population <- declare_population(N = 100, age = sample(18:95, N, replace = TRUE))

potential_outcomes_Y <- declare_potential_outcomes(Y ~ .25 * Z + .01 * age * Z)

assignment <- declare_assignment(m = 25)

potential_outcomes_attrition <- 
  declare_potential_outcomes(R ~ rbinom(n = N, size = 1, prob = pnorm(Y_Z_0)))

reveal_attrition <- reveal_outcomes(outcome_variables = "R")
reveal_outcomes <- reveal_outcomes(outcome_variables = "Y", attrition_variables = "R")

my_design <- population + potential_outcomes_Y + potential_outcomes_attrition + 
  my_assignment + reveal_attrition + reveal_outcomes

}
