/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import com.google.api.services.bigquery.model.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.starschema.clouddb.jdbc.BQConnection;
import net.starschema.clouddb.jdbc.BQSupportFuncts;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import org.antlr.runtime.tree.Tree;

public class SourceTable
extends Node {
    String name = null;
    String dataset = null;
    String project = null;
    String alias = null;
    TreeBuilder builder;
    private String uniqueId;

    public SourceTable(Tree t, TreeBuilder treeBuilder) throws TreeParsingException {
        this.builder = treeBuilder;
        this.uniqueId = this.builder.getuniqueid();
        this.build(t, this.builder);
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException {
        if (t.getType() == 124) {
            this.tokenName = JdbcGrammarParser.tokenNames[t.getType()];
            this.logger.debug("BUILDING " + this.tokenName);
            this.tokenType = t.getType();
            block12: for (int i = 0; i < t.getChildCount(); ++i) {
                Tree child = t.getChild(i);
                switch (child.getType()) {
                    case 94: {
                        this.name = child.getChild(0).getText();
                        continue block12;
                    }
                    case 31: {
                        this.dataset = child.getChild(0).getChild(0).getText();
                        continue block12;
                    }
                    case 110: {
                        this.project = "";
                        for (int k = 0; k < child.getChildCount(); ++k) {
                            this.project = this.project + child.getChild(k).getChild(0).getText();
                        }
                        continue block12;
                    }
                    case 5: {
                        this.alias = child.getChild(0).getText();
                        if (this.alias.equals("\"") || this.alias.equals("'")) {
                            this.alias = child.getChild(1).getText();
                        }
                        this.logger.debug("SOURCETABLE ALIAS: " + this.alias);
                        continue block12;
                    }
                }
            }
            if (this.dataset == null) {
                try {
                    this.dataset = ((BQConnection)builder.connection).getDataSet();
                }
                catch (ClassCastException i) {
                    // empty catch block
                }
            }
            if (this.dataset == null) {
                try {
                    ResultSet schemas = builder.connection.getMetaData().getSchemas();
                    schemas.first();
                    while (!schemas.isAfterLast()) {
                        try {
                            List<Table> tables = BQSupportFuncts.getTables((BQConnection)builder.connection, this.builder.connection.getCatalog(), schemas.getString(1), this.name);
                            if (tables != null) {
                                this.dataset = schemas.getString(1);
                                return;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        schemas.next();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new TreeParsingException("This Tree is not a SOURCETABLE");
        }
        this.logger.debug("Built up the sourcetable: " + this.name + " tables dataset is: " + this.dataset + " project is: " + (this.project != null ? this.project : "missing"));
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getName() {
        return this.name;
    }

    public String getProject() {
        return this.project;
    }

    public String getProjectDecoded() {
        return this.project.replace("__", ":").replace("_", ".");
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        String result = "";
        result = result + this.tab(level);
        if (this.project != null) {
            result = result + this.getProjectDecoded() + ":";
        }
        if (this.dataset != null) {
            result = result + this.dataset + ".";
        }
        result = result + this.name;
        if (this.alias != null) {
            result = result + " AS " + this.alias;
        }
        return result;
    }
}

