/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.BooleanExpressionItem;
import net.starschema.clouddb.jdbc.list.Conjunction;
import net.starschema.clouddb.jdbc.list.Negation;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import org.antlr.runtime.tree.Tree;

public class Disjunction
extends Node {
    /*
     * WARNING - void declaration
     */
    public Disjunction(Tree t, TreeBuilder builder, Node mainnode, SelectStatement selectstatement) throws TreeParsingException {
        this.tokenName = JdbcGrammarParser.tokenNames[t.getType()];
        this.tokenType = t.getType();
        this.logger.debug("BUILDING " + this.tokenName);
        ArrayList<Disjunction> disjunctionContainer = new ArrayList<Disjunction>();
        block6: for (int i = 0; i < t.getChildCount(); ++i) {
            Tree child = t.getChild(i);
            switch (child.getType()) {
                case 35: {
                    disjunctionContainer.add(new Disjunction(child, builder, mainnode, selectstatement));
                    this.logger.debug("APPENDING DISJUNCTION TO DISJUNCTION");
                    continue block6;
                }
                case 27: {
                    Node node = Conjunction.buildFromConjunction(child, builder, mainnode, selectstatement);
                    if (node.getTokenType() == 27) {
                        this.children.addLast(Conjunction.class.cast(node));
                        this.logger.debug("APPENDING CONJUNCTION AS PART OF DISJUNCTION");
                        continue block6;
                    }
                    disjunctionContainer.add((Disjunction)Disjunction.class.cast(node));
                    this.logger.debug("APPENDING DISJUNCTION AS PART OF DISJUNCTION");
                    continue block6;
                }
                case 95: {
                    this.children.addLast(new Negation(child, builder, mainnode, selectstatement));
                    continue block6;
                }
                case 13: {
                    Node item = new BooleanExpressionItem(child, builder, mainnode, selectstatement);
                    this.children.addLast(item);
                    this.logger.debug("APPENDING BOOLEANEXPRESSIONITEM TO DISJUNCTION: " + ((BooleanExpressionItem)item).toPrettyString());
                    continue block6;
                }
            }
        }
        if (disjunctionContainer.size() != 0) {
            for (Disjunction disjunction : disjunctionContainer) {
                for (Node item : disjunction.children) {
                    this.children.addLast(item);
                }
            }
        }
        ArrayList<Conjunction> selectedChildren = new ArrayList<Conjunction>();
        for (int i = 0; i < this.children.size(); ++i) {
            Node node = (Node)this.children.get(i);
            if (node.tokenType == 27) {
                void var11_25;
                Conjunction conjunctionMain = (Conjunction)Conjunction.class.cast(node);
                boolean foundLessRestrictive = false;
                boolean bl = false;
                while (var11_25 < this.children.size()) {
                    Node compareNode = (Node)this.children.get((int)var11_25);
                    if (compareNode.tokenType == 27) {
                        Conjunction conjunctionCompare = (Conjunction)Conjunction.class.cast(compareNode);
                        if (conjunctionCompare.children.size() < conjunctionMain.children.size()) {
                            boolean allfound = true;
                            for (Node BexprItem : conjunctionCompare.children) {
                                BooleanExpressionItem booleanExpressionItemC = (BooleanExpressionItem)BooleanExpressionItem.class.cast(BexprItem);
                                boolean found = false;
                                for (Node BexprItem2 : conjunctionMain.children) {
                                    BooleanExpressionItem booleanExpressionItemM = (BooleanExpressionItem)BooleanExpressionItem.class.cast(BexprItem2);
                                    if (!booleanExpressionItemC.equals(booleanExpressionItemM)) continue;
                                    found = true;
                                }
                                if (found) continue;
                                allfound = false;
                            }
                            if (allfound) {
                                foundLessRestrictive = true;
                            }
                        }
                    } else if (compareNode.tokenType == 13) {
                        boolean found = false;
                        for (Node BexprItem : conjunctionMain.children) {
                            BooleanExpressionItem booleanExpressionItemM = (BooleanExpressionItem)BooleanExpressionItem.class.cast(BexprItem);
                            if (!((BooleanExpressionItem)BooleanExpressionItem.class.cast(compareNode)).equals(booleanExpressionItemM)) continue;
                            found = true;
                        }
                        if (found) {
                            foundLessRestrictive = true;
                        }
                    }
                    ++var11_25;
                }
                if (foundLessRestrictive) continue;
                selectedChildren.add(conjunctionMain);
                continue;
            }
            if (node.tokenType != 13) continue;
            boolean found = false;
            for (Node node2 : selectedChildren) {
                if (node2.tokenType != 13 || !((BooleanExpressionItem)BooleanExpressionItem.class.cast(node2)).equals((BooleanExpressionItem)BooleanExpressionItem.class.cast(node))) continue;
                found = true;
            }
            if (found) continue;
            selectedChildren.add((Conjunction)this.children.get(i));
        }
        this.children = new LinkedList();
        for (Node node : selectedChildren) {
            this.children.addLast(node);
        }
    }

    public LinkedList<Node> getChildren() {
        return this.children;
    }

    private List<List<Node>> getallalternatives(List<Disjunction> disjunctionList) {
        this.logger.debug("DISTJUNCTION LIST SIZE:" + disjunctionList.size());
        ArrayList<List<Node>> alternativesReturn = new ArrayList<List<Node>>();
        if (disjunctionList.size() != 1) {
            List<List<Node>> alternativesnext = this.getallalternatives(disjunctionList.subList(1, disjunctionList.size()));
            for (Node node : disjunctionList.get((int)0).children) {
                for (List<Node> list : alternativesnext) {
                    ArrayList<Node> listTwo = new ArrayList<Node>();
                    listTwo.add(node);
                    listTwo.addAll(list);
                    alternativesReturn.add(listTwo);
                }
            }
        } else {
            for (Node node : disjunctionList.get((int)0).children) {
                ArrayList<Node> list2 = new ArrayList<Node>();
                list2.add(node);
                this.logger.debug("ADDING NODE TO DISTLIST:" + node.toPrettyString());
                alternativesReturn.add(list2);
            }
        }
        return alternativesReturn;
    }

    public Disjunction(List<Disjunction> disjunctionContainer, List<Conjunction> conjunctionContainer, List<Negation> negationContainer, List<BooleanExpressionItem> booleanExpressionItemContainer) {
        this.logger.debug("BUILDING DISTRIBUTIVE DISJUNCTION");
        Node mainConjunction = null;
        mainConjunction = conjunctionContainer.size() == 0 && negationContainer.size() == 0 && booleanExpressionItemContainer.size() == 1 ? (Node)booleanExpressionItemContainer.get(0) : (conjunctionContainer.size() == 1 && negationContainer.size() == 0 && booleanExpressionItemContainer.size() == 0 ? (Node)conjunctionContainer.get(0) : (conjunctionContainer.size() == 0 && negationContainer.size() == 1 && booleanExpressionItemContainer.size() == 0 ? (Node)negationContainer.get(0) : new Conjunction(conjunctionContainer, negationContainer, booleanExpressionItemContainer)));
        this.logger.debug("MAINJUNCTION BUILT");
        Disjunction mainDisjunction = disjunctionContainer.get(0);
        if (disjunctionContainer.size() != 1) {
            this.logger.debug("MORE ALTERNATIVES");
            ArrayList<Conjunction> disjunctionConjunctions = new ArrayList<Conjunction>();
            List<List<Node>> getAllAlternatives = this.getallalternatives(disjunctionContainer);
            for (List<Node> list : getAllAlternatives) {
                Conjunction conj = new Conjunction(list);
                this.logger.debug("ADDING ALTERNATIVE: " + conj.toPrettyString());
                disjunctionConjunctions.add(conj);
            }
            mainDisjunction = new Disjunction(disjunctionConjunctions);
        }
        ArrayList<Conjunction> conjunctions = new ArrayList<Conjunction>();
        for (Node node : mainDisjunction.children) {
            ArrayList<Node> nodelist = new ArrayList<Node>();
            nodelist.add(mainConjunction);
            nodelist.add(node);
            conjunctions.add(new Conjunction(nodelist));
        }
        for (Conjunction conjunction : conjunctions) {
            this.logger.debug("APPENDING CONJUNCTION TO DISJUNCTION");
            this.children.addLast(conjunction);
        }
        this.tokenType = 35;
        this.tokenName = JdbcGrammarParser.tokenNames[35];
    }

    public Disjunction(List<Conjunction> disjunctionConjunctions) {
        this.tokenType = 35;
        this.tokenName = JdbcGrammarParser.tokenNames[35];
        for (Node node : disjunctionConjunctions) {
            this.children.addLast(node);
        }
    }

    @Override
    public String toPrettyString(int level) {
        String result = "(";
        for (Node item : this.children) {
            result = result + item.toPrettyString() + " OR ";
        }
        result = result.substring(0, result.length() - 4) + ")";
        return result;
    }
}

