/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.services.bigquery.model.Job;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.starschema.clouddb.jdbc.BQConnection;
import net.starschema.clouddb.jdbc.BQForwardOnlyResultSet;
import net.starschema.clouddb.jdbc.BQQueryParser;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.BQScrollableResultSet;
import net.starschema.clouddb.jdbc.BQStatementRoot;
import net.starschema.clouddb.jdbc.BQSupportFuncts;

public class BQStatement
extends BQStatementRoot
implements Statement {
    private Job job;

    public BQStatement(String projectid, BQConnection bqConnection) {
        this.logger.debug("Constructor of BQStatement is running projectid is: " + projectid);
        this.ProjectId = projectid;
        this.connection = bqConnection;
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
    }

    public BQStatement(String projectid, BQConnection bqConnection, int resultSetType, int resultSetConcurrency) throws BQSQLException {
        this.logger.debug("Constructor of BQStatement is running projectid is: " + projectid + ",resultSetType is: " + resultSetType + ",resutSetConcurrency is: " + resultSetConcurrency);
        if (resultSetConcurrency == 1008) {
            throw new BQSQLException("The Resultset Concurrency can't be ResultSet.CONCUR_UPDATABLE");
        }
        this.ProjectId = projectid;
        this.connection = bqConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    @Override
    public ResultSet executeQuery(String querySql) throws SQLException {
        try {
            this.connection.addRunningStatement(this);
            ResultSet resultSet = this.executeQueryHelper(querySql);
            return resultSet;
        }
        finally {
            this.job = null;
            this.connection.removeRunningStatement(this);
        }
    }

    private ResultSet executeQueryHelper(String querySql) throws SQLException {
        Job referencedJob;
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        if (this.job != null) {
            throw new BQSQLException("Already running job");
        }
        this.starttime = System.currentTimeMillis();
        if (this.isNextvalQuery(querySql)) {
            return this.executeNextvalQuery(querySql);
        }
        BQQueryParser parser = new BQQueryParser(querySql, this.connection);
        querySql = parser.parse();
        try {
            referencedJob = this.startQuery(querySql);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the query: " + querySql, e);
        }
        try {
            do {
                if (this.connection.isClosed()) {
                    throw new BQSQLException("Connection is closed");
                }
                if (BQSupportFuncts.getQueryState(referencedJob, this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", ".")).equals("DONE")) {
                    if (this.resultSetType == 1004) {
                        return new BQScrollableResultSet(BQSupportFuncts.getQueryResults(this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."), referencedJob), this);
                    }
                    return new BQForwardOnlyResultSet(this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."), referencedJob, this);
                }
                Thread.sleep(500L);
                this.logger.debug("slept for 500ms, querytimeout is: " + this.querytimeout + "s");
            } while (System.currentTimeMillis() - this.starttime <= (long)this.querytimeout * 1000L);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the query: " + querySql, e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.cancel();
        throw new BQSQLException("Query run took more than the specified timeout");
    }

    public Job startQuery(String querySql) throws IOException {
        this.job = BQSupportFuncts.startQuery(this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."), querySql, this.connection.getDataSet(), this.connection.getUseLegacySql(), this.connection.getMaxBillingBytes());
        this.logger.debug("BQStatement::startQuery: " + querySql);
        return this.job;
    }

    public Job getJob() {
        return this.job;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.job == null) {
            return;
        }
        try {
            BQSupportFuncts.cancelQuery(this.job, this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."));
        }
        catch (IOException e) {
            throw new SQLException("Failed to kill query");
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public void close() throws SQLException {
        this.cancel();
        super.close();
    }
}

