% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbCreateTable,DatabaseConnectorConnection,character,data.frame-method}
\alias{dbCreateTable,DatabaseConnectorConnection,character,data.frame-method}
\title{Create a table in the database}
\usage{
\S4method{dbCreateTable}{DatabaseConnectorConnection,character,data.frame}(
  conn,
  name,
  fields,
  oracleTempSchema = NULL,
  ...,
  row.names = NULL,
  temporary = FALSE
)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{Name of the table, escaped with \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[DBI:dbDataType]{dbDataType()}}.}

\item{oracleTempSchema}{Specifically for Oracle, a schema with write priviliges where temp tables
can be created.}

\item{...}{Other arguments used by individual methods.}

\item{row.names}{Must be \code{NULL}.}

\item{temporary}{Should the table created as a temp table?}
}
\description{
The default \code{dbCreateTable()} method calls \code{\link[DBI:sqlCreateTable]{sqlCreateTable()}} and
\code{\link[DBI:dbExecute]{dbExecute()}}.
Backends compliant to ANSI SQL 99 don't need to override it.
Backends with a different SQL syntax can override \code{sqlCreateTable()},
backends with entirely different ways to create tables need to
override this method.
}
\details{
The \code{row.names} argument is not supported by this method.
Process the values with \code{\link[DBI:sqlRownamesToColumn]{sqlRownamesToColumn()}} before calling this method.

The argument order is different from the \code{sqlCreateTable()} method, the
latter will be adapted in a later release of DBI.
}
\seealso{
Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}
}
