% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prcomp.r
\name{plot_prcomp}
\alias{plot_prcomp}
\title{Visualize principal component analysis}
\usage{
plot_prcomp(
  data,
  variance_cap = 0.8,
  maxcat = 50L,
  prcomp_args = list(scale. = TRUE),
  geom_label_args = list(),
  title = NULL,
  ggtheme = theme_gray(),
  theme_config = list(),
  nrow = 3L,
  ncol = 3L,
  parallel = FALSE
)
}
\arguments{
\item{data}{input data}

\item{variance_cap}{maximum cumulative explained variance allowed for all principal components. Default is 80\%.}

\item{maxcat}{maximum categories allowed for each discrete feature. The default is 50.}

\item{prcomp_args}{a list of other arguments to \link{prcomp}}

\item{geom_label_args}{a list of other arguments to \link{geom_label}}

\item{title}{plot title starting from page 2.}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{nrow}{number of rows per page}

\item{ncol}{number of columns per page}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
Visualize output of \link{prcomp}.
}
\details{
When cumulative explained variance exceeds \code{variance_cap}, remaining principal components will be ignored. Set \code{variance_cap} to 1 for all principal components.

Discrete features containing more categories than \code{maxcat} specifies will be ignored.
}
\note{
Discrete features will be \link{dummify}-ed first before passing to \link{prcomp}.

Missing values may create issues in \link{prcomp}. Consider \link{na.omit} your input data first.

Features with zero variance are dropped.
}
\examples{
plot_prcomp(na.omit(airquality), nrow = 2L, ncol = 2L)
}
\keyword{plot_prcomp}
