% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_report.r
\name{create_report}
\alias{create_report}
\title{create_report Function}
\usage{
create_report(data, output_file = "report.html", output_dir = getwd(),
  y = NULL, config = list(), ...)
}
\arguments{
\item{data}{input data}

\item{output_file}{output file name. The default is "report.html".}

\item{output_dir}{output directory for report. The default is user's current directory.}

\item{y}{name of response variable if any. Response variables will be passed to appropriate plotting functions automatically.}

\item{config}{report configuration with function arguments as \link{list}. See details.}

\item{\dots}{other arguments to be passed to \link{render}.}
}
\description{
This function creates a data profiling report.
}
\details{
\code{config} is a named list to be evaluated by \code{create_report}.
Each name should exactly match a function name.
By doing so, that function and corresponding content will be added to the report.
If you do not want to include certain functions/content, do not add it to \code{config}.

By default, there is a preset \code{config} object (refer to example).
In case you would like to customize the report, copy and edit the code and pass it to \code{config} argument.

All function arguments will be passed to \link{do.call} as a list.
}
\note{
If both \code{y} and \code{plot_prcomp} are present, \code{y} will be removed from \code{plot_prcomp}.

If there are multiple options for the same function, all of them will be plotted.
For example, \code{create_report(..., y = "a", config = list("plot_bar" = list("with" = "b")))} will create 3 bar charts:
\itemize{
\item regular frequency bar chart
\item bar chart aggregated by response variable "a"
\item bar chart aggregated by `with` variable "b"`
}
}
\examples{
\dontrun{
#############################
## Default config file     ##
## Copy and edit if needed ##
#############################
config <- list(
  "introduce" = list(),
  "plot_str" = list(
    "type" = "diagonal",
    "fontSize" = 35,
    "width" = 1000,
    "margin" = list("left" = 350, "right" = 250)
  ),
  "plot_missing" = list(),
  "plot_histogram" = list(),
  "plot_qq" = list(sampled_rows = 1000L),
  "plot_bar" = list(),
  "plot_correlation" = list("cor_args" = list("use" = "pairwise.complete.obs")),
  "plot_prcomp" = list(),
  "plot_boxplot" = list(),
  "plot_scatterplot" = list(sampled_rows = 1000L)
)

# Create report
create_report(iris)
create_report(airquality, y = "Ozone")

# Load library
library(ggplot2)
library(data.table)
library(rmarkdown)

# Set some missing values
diamonds2 <- data.table(diamonds)
for (j in 5:ncol(diamonds2)) {
  set(diamonds2,
      i = sample.int(nrow(diamonds2), sample.int(nrow(diamonds2), 1)),
      j,
      value = NA_integer_)
}

# Create customized report for diamonds2 dataset
create_report(
  data = diamonds2,
  output_file = "report.html",
  output_dir = getwd(),
  y = "price",
  config = list(
    "introduce" = list(),
    "plot_missing" = list(),
    "plot_histogram" = list(),
    "plot_qq" = list("by" = "cut", sampled_rows = 1000L),
    "plot_bar" = list("with" = "carat"),
    "plot_correlation" = list("cor_args" = list("use" = "pairwise.complete.obs")),
    "plot_prcomp" = list(),
    "plot_boxplot" = list("by" = "cut")
  ),
  html_document(toc = TRUE, toc_depth = 6, theme = "flatly")
)
}
}
\keyword{create_report}
