% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateReport.r
\name{GenerateReport}
\alias{GenerateReport}
\title{GenerateReport Function}
\usage{
GenerateReport(input_data, output_file = "report.html",
  output_dir = getwd(), ...)
}
\arguments{
\item{input_data}{data source to be profiled, in either \link{data.frame} or \link{data.table} format.}

\item{output_file}{output file name. The default is "report.html".}

\item{output_dir}{output directory for report. The default is user's current directory.}

\item{\dots}{other arguments to be passed to \link{render}.}
}
\description{
This function generates the report of data profiling.
}
\examples{
\dontrun{
# load library
library(rmarkdown)
library(ggplot2)
library(data.table)

# load data
data(diamonds)
diamonds2 <- data.table(diamonds)

# manually set some missing values
for (j in 5:ncol(diamonds2)) {
  set(diamonds2,
      i = sample.int(nrow(diamonds2), sample.int(nrow(diamonds2), 1)),
      j,
      value = NA_integer_)}

# generate report for diamonds dataset
GenerateReport(diamonds2,
               output_file = "report.html",
               output_dir = getwd(),
               html_document(toc = TRUE, toc_depth = 6, theme = "flatly"))
}
}
\keyword{generatereport}

