% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HistogramContinuous.r
\name{HistogramContinuous}
\alias{HistogramContinuous}
\title{Create histogram for continuous features}
\usage{
HistogramContinuous(data, ...)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{\dots}{other arguments to be passed to \link{geom_histogram}.}
}
\description{
This function creates histogram for each continuous feature.
}
\examples{
# load library
library(data.table)

# plot using iris data
HistogramContinuous(iris)

# plot using random data
set.seed(1)
data <- cbind(sapply(1:9, function(x) {rnorm(10000, sd = 30 * x)}))
HistogramContinuous(data, breaks = seq(-400, 400, length = 10))
}
\keyword{histogramcontinuous}

