% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dssbatch.R
\name{read_dssbatch}
\alias{read_dssbatch}
\title{Reads data from a single DSSAT batch file}
\usage{
read_dssbatch(file_name = "DSSBatch.V47")
}
\arguments{
\item{file_name}{a character vector of length one that contains the name
of a single DSSAT batch file}
}
\value{
a tibble containing the data from the DSSAT batch file
}
\description{
Reads data from a single DSSAT batch file
}
\examples{

# Create example batch file path
batch_file_path <- paste0(tempdir(),'/DSSBatch.V47')

# Write example batch file
write_dssbatch(x='UFGA0601.BMX',trtno=1:4,file_name = batch_file_path)

# Read example batch file
dssbatch <- read_dssbatch(batch_file_path)

}
