% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalResult.R
\name{dsGetInfo,OpalResult-method}
\alias{dsGetInfo,OpalResult-method}
\title{Get result info}
\usage{
\S4method{dsGetInfo}{OpalResult}(dsObj, ...)
}
\arguments{
\item{dsObj}{\code{\link{OpalResult-class}} class object}

\item{...}{Unused, needed for compatibility with generic.}
}
\value{
The result information, including its status.
}
\description{
Get the information about a command (if still available).
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "username", "password", "https://opal.example.org")
dsAssignExpr(con, "C", as.symbol("c(1, 2, 3)"))
res <- dsAggregate(con, as.symbol("length(C)"))
dsGetInfo(res)
dsDisconnect(con)
}

}
