% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.connections.R
\name{datashield.connections_find}
\alias{datashield.connections_find}
\title{Search for DSConnection objects in the analytic environment}
\usage{
datashield.connections_find(env = getOption("datashield.env", globalenv()))
}
\arguments{
\item{env}{The environment where to search for the connection symbols. Try to get it from the
'datashield.env' option, with default to the Global Environment.}
}
\value{
Returns a list of \code{\link{DSConnection-class}} objects or stops the process
}
\description{
If the user does not set the argument 'datasources' in the client side analysis functions, this function
is called to search for \code{\link{DSConnection-class}} objects in the environment (default
environment is the Global one). If one set of DSConnection objects is found, it is assigned
to 'default.connections' symbol in the analytic environment. If more than one set of DSConnection
objects is found and none of them is called 'default.connections', the function stops and
suggests user to use the \link{datashield.connections_default} function.
}
\seealso{
Other Connections management: 
\code{\link{datashield.connections_default}()},
\code{\link{datashield.connections}()}
}
\concept{Connections management}
