% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_basicvirus_stochastic.R
\name{simulate_basicvirus_stochastic}
\alias{simulate_basicvirus_stochastic}
\title{Stochastic simulation of a compartmental acute virus infection model}
\usage{
simulate_basicvirus_stochastic(U = 10000, I = 0, V = 5, n = 0,
  dU = 0, b = 1e-04, dI = 1, p = 10, dV = 2, rngseed = 100,
  tfinal = 30)
}
\arguments{
\item{U}{: initial number of target cells. Needs to be an integer : numeric}

\item{I}{: initial number of wild-type infected cells. Needs to be an integer. : numeric}

\item{V}{: initial number of resistant virus. Needs to be an integer. : numeric}

\item{n}{: rate of uninfected cell production : numeric}

\item{dU}{: rate of uninfected cell removal : numeric}

\item{b}{: level/rate of infection of cells : numeric}

\item{dI}{: rate of infected cell death : numeric}

\item{p}{: virus production rate : numeric}

\item{dV}{: virus removal rate : numeric}

\item{rngseed}{: seed for random number generator to allow reproducibility : numeric}

\item{tfinal}{: Final time of simulation : numeric}
}
\value{
A list. The list has only one element called ts.
ts contains the time-series of the simulation.
The 1st column of ts is Time, the other columns are the model variables.
}
\description{
Simulation of a stochastic model with the following compartments:
Uninfected target cells (U), Infected cells (I), virus (V).
}
\details{
A compartmental ID model with several states/compartments
is simulated as a stochastic model using the adaptive tau algorithm as implemented by ssa.adaptivetau()
in the adaptivetau package. See the manual of this package for more details.
This code is part of the DSAIRM R package.
For additional model details, see the corresponding app in the DSAIRM package.
}
\section{Warning}{

This function does not perform any error checking. So if you try to do
something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_basicvirus_stochastic()
# To choose parameter values other than the standard one, specify them, like such:
result <- simulate_basicvirus_stochastic(U = 1e3, dI = 0.1)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"time"],result$ts[,"V"],xlab='Time',ylab='Virus',type='l')
}
