% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_virus_tx.R
\name{simulate_virus_tx}
\alias{simulate_virus_tx}
\title{Simulation of a basic viral infection model without an immune response}
\usage{
simulate_virus_tx(U0 = 1e+05, I0 = 0, V0 = 1, tmax = 30,
  n = 10000, dU = 0.1, dI = 1, dV = 2, b = 1e-05, p = 10,
  g = 1, f = 0, e = 0, steadystate = FALSE, txstart = 0)
}
\arguments{
\item{U0}{initial number of uninfected target cells}

\item{I0}{initial number of infected target cells}

\item{V0}{initial number of infectious virions}

\item{tmax}{maximum simulation time, units depend on choice of units for your
parameters}

\item{n}{rate of new uninfected cell replenishment}

\item{dU}{rate at which uninfected cells die}

\item{dI}{rate at which infected cells die}

\item{dV}{rate at which infectious virus is cleared}

\item{b}{rate at which virus infects cells}

\item{p}{rate at which infected cells produce virus}

\item{g}{conversion between experimental and model virus units}

\item{f}{strength of cell infection reduction by drug (0-1)}

\item{e}{strength of virus production reduction by drug (0-1)}

\item{steadystate}{if this is set to TRUE, the starting values for U, I and V are set
to their steady state values. User supplied values for U0, I0, V0 are ignored.}

\item{txstart}{time at which treatment starts}
}
\value{
A list. The list has only one element called ts.
ts contains the time-series of the simulation.
The 1st column of ts is Time, the other columns are the model variables.
}
\description{
This function runs a simulation of a compartment model
using a set of ordinary differential equations.
The model describes a simple viral infection system in the presence of drug treatment.
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
The function returns a list containing time-series of each variable and time.
}
\details{
A simple compartmental model is simulated as a set of ordinary differential
equations, using an ode solver from the deSolve package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_virus_tx()
# To choose parameter values other than the standard one, specify them, like such:
result <- simulate_virus_tx(V0 = 100, tmax = 100, n = 1e5, dU = 1e-2)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"Time"],result$ts[,"V"],xlab='Time',ylab='Virus',type='l',log='y')
}
\seealso{
See the Shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the deSolve
package for details on the underlying ODE simulator algorithm.
}
\author{
Andreas Handel
}
