% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataAccess.R
\name{varDataAccess}
\alias{varDataAccess}
\title{Differentially Private Variance Data Access Function}
\usage{
varDataAccess(x, lower.bound, upper.bound)
}
\arguments{
\item{x}{Dataset whose variance is desired.}

\item{lower.bound}{Scalar representing the global or public lower bound on
values of x.}

\item{upper.bound}{Scalar representing the global or public upper bound on
values of x.}
}
\value{
List of the true variance and the sensitivity calculated based on
theoretical values.
}
\description{
This function performs the data access step in the computation of a
differentially private variance. The true values are computed using
\code{\link[stats]{var}}, while the sensitivities are calculated based on
bounded and unbounded differential privacy \insertCite{Kifer2011}{DPpack}
according to the theoretical values \insertCite{Liu2019b}{DPpack}. For the
variance, the sensitivities based on bounded and unbounded differential
privacy are identical, so only one value is returned.
}
\examples{
varDataAccess(c(1,4,3,2), 0, 5)

}
\references{
\insertRef{Liu2019b}{DPpack}

\insertRef{Kifer2011}{DPpack}
}
\keyword{internal}
