% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSAPC.R
\name{DSAPC}
\alias{DSAPC}
\title{The distributed stochastic approximation principal component for handling online data sets with highly correlated data across multiple nodes.}
\usage{
DSAPC(data, m, eta, n1, K)
}
\arguments{
\item{data}{is a highly correlated online data set}

\item{m}{is the number of principal component}

\item{eta}{is the proportion of online data to total data}

\item{n1}{is the length of each data subset}

\item{K}{is the number of nodes}
}
\value{
Asa, Dsa (lists containing results from each node)
}
\description{
The distributed stochastic approximation principal component for handling online data sets with highly correlated data across multiple nodes.
}
\examples{
library(LFM)
data_from_package <- Wine
data_a <- Wine
DSAPC(data=data_a, m=3, eta=0.8, n1=128, K=2)
}
