% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DImulti_predict.R
\name{predict.DImulti}
\alias{predict.DImulti}
\title{predict.DImulti}
\usage{
\method{predict}{DImulti}(object, newdata = NULL, stacked = TRUE, ...)
}
\arguments{
\item{object}{an object of class DImulti}

\item{newdata}{an optional dataframe containing the communities from which to predict. If data is
multivariate and in a wide format, to predict from a subset of ecosystem functions, as opposed
to all, please include a column for each function with any numerical value, e.g.
\code{newdata$Y2 <- 0}. If predicting from all functions, these columns may be included or left
out.}

\item{stacked}{a logical value used to determine whether the output is in a wide or stacked
format. Defaults to TRUE, meaning output is stacked/long. \cr If set to FALSE, non-unique groups of
unit_IDs, ecosystem function, and time points will be aggregated upon widening using the mean
function, please use unique unit_IDs values through newdata to avoid aggregation.}

\item{...}{some methods for this generic function require additional arguments. None are used in
this method.}
}
\value{
The predictions from the supplied fitted DI models for the provided 'newdata', or the
data used to fit the model if no 'newdata' is supplied. Predictions are returned in either a
stacked or wide dataframe format.
}
\description{
Predict from a multivariate repeated measures DI model
}
\seealso{
\code{\link[nlme]{predict.gls}} which this function wraps.
}
