% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{getObservedResponse}
\alias{getObservedResponse}
\alias{getObservedResponse.default}
\alias{getObservedResponse.HLfit}
\title{Get model response}
\usage{
getObservedResponse(object, ...)

\method{getObservedResponse}{default}(object, ...)

\method{getObservedResponse}{HLfit}(object, ...)
}
\arguments{
\item{object}{a fitted model}

\item{...}{additional parameters}
}
\description{
Extract the response of a fitted model
}
\details{
The purpose of this function is to savely extract the response (dependent variable) of the fitted model classes
}
\examples{
testData = createData(sampleSize = 400, family = gaussian())

fittedModel <- lm(observedResponse ~ Environment1 , data = testData)

# response that was used to fit the model
getObservedResponse(fittedModel)

# predictions of the model for these points
getFitted(fittedModel)

# extract simulations from the model as matrix
getSimulations(fittedModel, nsim = 2)

# extract simulations from the model for refit (often requires different structure)
x = getSimulations(fittedModel, nsim = 2, type = "refit")

getRefit(fittedModel, x[[1]])

getRefit(fittedModel, getObservedResponse(fittedModel))
}
\seealso{
\code{\link{getRefit}}, \code{\link{getSimulations}}, \code{\link{getFixedEffects}}, \code{\link{getFitted}}
}
\author{
Florian Hartig
}
