% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResiduals.R
\name{plotQQunif}
\alias{plotQQunif}
\title{Quantile-quantile plot for a uniform distribution}
\usage{
plotQQunif(simulationOutput, testUniformity = T)
}
\arguments{
\item{simulationOutput}{a DHARMa simulation output (class DHARMa)}

\item{testUniformity}{if T, the function \code{\link{testUniformity}} will be called and the result will be added to the plot}
}
\description{
The function produces a uniform quantile-quantile plot from a DHARMa output
}
\details{
the function calls qqunif from the R package gap to create a quantile-quantile plot for a uniform distribution.
}
\examples{
testData = createData(sampleSize = 200, family = poisson(), 
                      randomEffectVariance = 0, numGroups = 5)
fittedModel <- glm(observedResponse ~ Environment1, 
                   family = "poisson", data = testData)
simulationOutput <- simulateResiduals(fittedModel = fittedModel)

######### main plotting function #############

# for all functions, quantreg = T will be more
# informative, but slower

plot(simulationOutput, quantreg = FALSE)

#############  qq plot  ######################

plotQQunif(simulationOutput = simulationOutput)

#############  residual plots  ###############

# rank transformation, using a simulationOutput
plotResiduals(simulationOutput, rank = TRUE, quantreg = FALSE)

# residual vs predictors, using explicit values for pred, residual 
plotResiduals(pred = testData$Environment1, 
              residuals = simulationOutput$scaledResiduals, quantreg = FALSE)

# if pred is a factor, or asFactor = T, will produce a boxplot
plotResiduals(pred = testData$group, residuals = simulationOutput$scaledResiduals, 
              quantreg = FALSE, asFactor = TRUE)

# All these options can also be provided to the main plotting function
plot(simulationOutput, quantreg = FALSE, rank = FALSE)

# If you want to plot summaries per group, use
simulationOutput = recalculateResiduals(simulationOutput, group = testData$group)
plot(simulationOutput, asFactor = TRUE) # we see one residual point per RE


}
\seealso{
\code{\link{plotSimulatedResiduals}}, \code{\link{plotResiduals}}
}
