% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleGO.R
\name{plotModuleGO}
\alias{plotModuleGO}
\title{Plot extracted results from module-based GO enrichment analysis using ggplot2.}
\usage{
plotModuleGO(df, nTerms = 5, termVector = NULL, modules = NULL,
  heatmapColor = NULL, plotOR = FALSE, axis_text_col = "black",
  axis_x_text_angle = 45, text_size = 10, guide_title = NULL,
  coord_flip = FALSE, adjust = TRUE)
}
\arguments{
\item{df}{The data frame of term enrichments to be plotted.}

\item{nTerms}{The number of terms for each module whose GO terms with the minimum enrichment p-values for that group should be plotted.}

\item{termVector}{Optional character vector of GO term strings to plot, overriding other options.}

\item{modules}{Optional, a list of module names to plot. Optional; if not inputted, all of the module names in the data frame will be used.}

\item{heatmapColor}{Optional specification of the heatmap colors. If not specified, ?heat.colors will be used.}

\item{plotOR}{Logical, indicating whether odds ratios should be plotted on the heatmap, instead of -log10 p-values (the default).}

\item{axis_text_col}{Color of axis text.}

\item{axis_x_text_angle}{Angle of x-axis text.}

\item{text_size}{Text size of axes and legend in plot.}

\item{guide_title}{Optionally, specify the title of legend.}

\item{coord_flip}{Whether the coordinates should be flipped.}

\item{adjust}{If p-values are plotted, whether or not the enrichment p-values from each module should be adjusted by the Benjamini-Hochberg method.}
}
\value{
A data frame summarizing the GO term enrichments from each group, with columns on the ordered by the minimum p-value for OR term enrichment in any group.
}
\description{
Takes a data frame of enrichment results in multiple modules and plots the results. Note that if a GO term enrichment does not exist for that module, it is set as 0 for an OR or 1 for a p-value.
}

