% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{extractVcf}
\alias{extractVcf}
\title{Extract VCF information}
\usage{
extractVcf(filename)
}
\arguments{
\item{filename}{VCF file name.}
}
\value{
A dataframe list with members of haplotypes, proportions and log likelihood of the MCMC chain.
\itemize{
  \item \code{CHROM} SNP chromosomes.
  \item \code{POS} SNP positions.
  \item \code{refCount} reference allele count.
  \item \code{altCount} alternative allele count.
}
}
\description{
Extract VCF information
}
\examples{
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
vcf = extractVcf(vcfFile)

}
\seealso{
\itemize{
  \item \code{extractCoverageFromVcf}
  \item \code{extractCoverageFromTxt}
}
}
