% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{plotAltVsRef}
\alias{plotAltVsRef}
\title{Plot coverage}
\usage{
plotAltVsRef(
  ref,
  alt,
  title = "Alt vs Ref",
  exclude.ref = c(),
  exclude.alt = c(),
  potentialOutliers = c(),
  cex.lab = 1,
  cex.main = 1,
  cex.axis = 1
)
}
\arguments{
\item{ref}{Numeric array of reference allele count.}

\item{alt}{Numeric array of alternative allele count.}

\item{title}{Figure title, "Alt vs Ref" by default}

\item{exclude.ref}{Numeric array of reference allele count at sites that are
not deconvoluted.}

\item{exclude.alt}{Numeric array of alternative allele count at sites that
are not deconvoluted}

\item{potentialOutliers}{Index of potential outliers.}

\item{cex.lab}{Label size.}

\item{cex.main}{Title size.}

\item{cex.axis}{Axis text size.}
}
\description{
Plot alternative allele count vs reference allele count at each
 site.
}
\examples{
# Example 1
refFile = system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile = system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageT = extractCoverageFromTxt(refFile, altFile)
plotAltVsRef(PG0390CoverageT$refCount, PG0390CoverageT$altCount)

# Example 2
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV = extractCoverageFromVcf(vcfFile)
plotAltVsRef(PG0390CoverageV$refCount, PG0390CoverageV$altCount)

}
