% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{get_de_data}
\alias{get_de_data}
\title{Aggregate and retrieve data from multiple differentially expressed result sets.}
\usage{
get_de_data(res_list, method = "union", type = "lfc",
  lfc_filter = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets created with DESeq2::results(). I.E: list(res1, res2, ..., resN).}

\item{method}{Method for aggregating data.  "union" will gather expression data for all samples in results list
when a gene is differentially expressed in at least one sample.  "intersection" will gather expression data only for genes that
are DE in all samples of the result list.}

\item{type}{Type of data to retrieve.  Options are "lfc" (log2foldchange) and "padj" (adjusted p-value).}

\item{lfc_filter}{Filter genes based on a minimum log fold-change as initialized in init_cutoffs(). Boolean. Default=FALSE.}
}
\value{
Returns the aggregated data frame containing fold-change or p-values for the provided result sets.
}
\description{
This function finds the union or intersection of DE gene names for all result sets provided, extracts those rows
from all DE result sets, and merges the values into a single data set containing log2 fold-change or padj values.
}
\examples{
\dontrun{

#Prepare a result list for aggregation.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)


/*
 * Data for all result sets will be included for each gene if that gene was found to be
 * differentially expressed in at least one of the provided result sets.
 * Filter based on a minimum fold-change.
 */
aggregated_lfc_union  <- get_de_data(res_list=myResList, method="union",
                                      type="lfc", lfc_filter=TRUE)
aggregated_pval_union <- get_de_data(res_list=myResList, method="union",
                                      type="padj", lfc_filter=TRUE)


/*
 * Data for all result sets will be included for each gene only if that gene was found to
 * be differentially expressed in all provided result sets. Do not apply a fold-change filter.
 * Significance is determined only by p-value threshold.
 */
aggregated_lfc_intersect  <- get_de_data(res_list=myResList, method="intersection",
                                          type="lfc", lfc_filter=FALSE)
aggregated_pval_intersect <- get_de_data(res_list=myResList, method="intersection",
                                          type="padj", lfc_filter=FALSE)

}
}
\seealso{
\code{\link{init_cutoffs}}
}
\keyword{DE}
\keyword{aggregate}
\keyword{filter}
