% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovarianCancer-data.R
\docType{data}
\name{ovarianCancer}
\alias{ovarianCancer}
\title{Ovarian Cancer (NCI PBSII Data)}
\format{An object of class \code{"data.frame"}.}
\source{
\href{http://leo.ugr.es/elvira/DBCRepository/OvarianCancer/Ovarian-PBSII-061902.zip}{ZIP Archive}
}
\usage{
data(ovarianCancer)
}
\description{
The database used correspond to proteomic spectra, generated by mass spectroscopy. This data dates from 6-19-02, 
and includes 91 controls (Normal) and 162 ovarian cancers. The raw spectral data of each sample contains the relative 
amplitude of the intensity at each molecular mass/charge (M/Z) identity. There are total 15154 M/Z identities. 
The intensity values were normalized according to the formula: NV = (V-Min)/(Max-Min) where NV is the normalized 
value, V$ the raw value, $Min$ the minimum intensity and $Max$ the maximum intensity. The normalization is done over 
all the 253 samples for all 15154 M/Z identities. After the normalization, each intensity value is to fall within the 
range of 0 to 1.
}
\examples{
data(ovarianCancer)
responses <- data.frame(ovarianCancer$response)
predictors <- data.frame(
  n1 = as.numeric(as.numeric(ovarianCancer[[2]])),
  n2 = as.numeric(as.numeric(ovarianCancer[[3]]))
)
names(predictors) = c("Protein 1689","Protein 1737")
detcurve <- detc(responses,predictors, 
                 names = names(predictors),
                 positive = "Cancer",
                 title = "Proteomic patterns",
                 plotROC = TRUE)

}
\references{
Emanuel F Petricoin et al. (2002) The Lancet 359:572-577
(\href{http://leo.ugr.es/elvira/DBCRepository/OvarianCancer/OvarianCancer-NCI-PBSII.html}{PubMed})
}
\keyword{cancer}
\keyword{datasets}
\keyword{ovarian}
