% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_methods.R
\name{read.DeponsTrackBatch}
\alias{read.DeponsTrackBatch}
\title{Read and Process DEPONS Batchmap and Statistics Files}
\usage{
read.DeponsTrackBatch(
  dir,
  par,
  title = "NA",
  landscape = "NA",
  simtime = "NA",
  crs = as.character(NA),
  tz = "UTC"
)
}
\arguments{
\item{dir}{Character string specifying the directory path containing the `Batchmap` and `RandomPorpoise` files}

\item{par}{Character vector specifying the column names to extract from the batch map file for each run.
These parameters are then stored in the `Parameters` list}

\item{title}{Optional character string giving name of simulation}

\item{landscape}{Character string. Name of the simulation landscape}

\item{simtime}{Character sting with date of simulation (format yyyy-mm-dd).
If not provided this is obtained from name of input file}

\item{crs}{Character, coordinate reference system (map projection)}

\item{tz}{Time zone used in simulations. Defaults to UTC/GMT}
}
\value{
A list of `DeponsTrack` objects and parameter values associated with run id
}
\description{
Reads batch map files and random porpoise files from a specified directory, merges
them for each run, and returns a list of `DeponsTrack` objects and parameter values
}
\examples{
\dontrun{
# Specify the directory containing Batchmap and Statistics files
dir_path <- "path/to/batchdata"

# Specify parameters to extract from Batchmap files
par <- c("parameter1", "parameter2")

# Run the function
results <- read.DeponsBatch(
  dir = dir_path,
  par = par,
  crs = "+proj=longlat +datum=WGS84"
)
}
}
