% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{plot.LN}
\alias{plot.LN}
\title{Density Plot by Lognormal kernel}
\usage{
\method{plot}{LN}(x, ...)
}
\arguments{
\item{x}{An object of class "LN"}

\item{\dots}{Not presently used in this implementation}
}
\value{
Nothing
}
\description{
Plot Kernel density by using Lognormal Kernel.
}
\examples{
y <- rexp(23,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
den <- LN(y,90,h)
plot(den, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")
## To add true density along with estimated
d1 <- density(y,bw=h)
lines(d1,type="p",col="red")
}
\references{
Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103–124.
}
\seealso{
For further kernels see \code{\link{plot.Erlang}}, \code{\link{plot.Gamma}} and \code{\link{plot.BS}}. To calculate MSE by using Lognormal Kernel \code{\link{mseLN}} and for estimated values for density
estimation see \code{\link{LN}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
