% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDL.R
\name{DDL}
\alias{DDL}
\title{Point estimation and inference for a single regression coefficient in the high-dimensional linear model with hidden confounders.}
\usage{
DDL(X, Y, idx, alpha = 0.05, rho = 0.5, rhop = 0.5)
}
\arguments{
\item{X}{the covariates matrix, of dimension \eqn{n\times p}}

\item{Y}{the outcome vector, of length \eqn{n}}

\item{idx}{the index for the regression coefficient of interest}

\item{alpha}{the significance level of the confidence interval, default is 0.05}

\item{rho}{the trim level for \eqn{X}, default is 0.5}

\item{rhop}{the trim level for \eqn{X_{-j}}, default is 0.5}
}
\value{
\item{point}{The Doubly Debiased Lasso estimator of the target regression coefficient}
\item{se}{The standard error of the Doubly Debiased Lasso estimator}
\item{CI}{The confidence interval for the target regression coefficient}
\item{beta0}{The spectral deconfounding estimator of the whole regression vector}
}
\description{
Computes the Doubly Debiased Lasso estimator of a single regression coefficient in the high-dimensional linear model with hidden confounders. It also constructs the confidence interval for the target regression coefficient.
}
\examples{
idx = 1
n=100
p=200
s=5
q=3
sigmaE=2
sigma=2
pert=1

H = pert*matrix(rnorm(n*q,mean=0,sd=1),n,q,byrow = TRUE)
Gamma = matrix(rnorm(q*p,mean=0,sd=1),q,p,byrow = TRUE)
#value of X independent from H
E = matrix(rnorm(n*p,mean=0,sd=sigmaE),n,p,byrow = TRUE)

#defined in eq. (2), high-dimensional measured covariates
X = E + H \%*\% Gamma

delta = matrix(rnorm(q*1,mean=0,sd=1),q,1,byrow = TRUE)

#px1 matrix, creates beta with 1s in the first s entries and the remaining p-s as 0s
beta = matrix(rep(c(1,0),times = c(s,p-s)),p,1,byrow = TRUE)

#nx1 matrix with values of mean 0 and SD of sigma, error in Y independent of X
nu = matrix(rnorm(n*1,mean=0,sd=sigma),n,1,byrow = TRUE)

#eq. (1), the response of the Structural Equation Model
Y = X \%*\% beta + H \%*\% delta + nu

result = DDL(X, Y, idx)
}
