% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCS_MainFunctions.R
\name{dcs}
\alias{dcs}
\title{Nonparametric Double Conditional Smoothing for 2D Surfaces}
\usage{
dcs(Y, dcs_options = set.options(), h = "auto", ...)
}
\arguments{
\item{Y}{A numeric matrix that contains the observations of the random field
or functional time-series.}

\item{dcs_options}{An object of class \code{"dcs_options"}, specifying the
parameters for the smoothing and bandwidth selection procedure.}

\item{h}{Bandwidth for smoothing the observations in \code{Y}. Can be a
two-valued numerical vector with bandwidths in row- and column-direction.
If the value is \code{"auto"} (the default), bandwidth selection will be 
carried out by the iterative plug-in algorithm.}

\item{...}{Additional arguments passed to \code{dcs}. These might include
numerical vectors \code{X} and/or \code{T} containing the exogenous
covariates with respect to the rows and columns. If \code{var_est} is any of
\code{"qarma"}, \code{"sarma"} or \code{"lm"}, \code{model_order} is an 
optional list containing the two-dimensional model orders in the form 
\code{list(ar = c(1, 1), ma = c(1, 1)}. If \code{var_est} is any of
\code{"qarma_gpac"} or \code{"qarma_bic"}, \code{order_max} an optional list
containing the two dimensional maximum orders for the order selection of the
QARMA estimation in the form \code{list(ar = c(1, 1), ma = c(1, 1)}.}
}
\value{
\code{DCSmooth} returns an object of class "dcs", including
 \tabular{ll}{
 \code{Y} \tab matrix of original observations. \cr
 \code{X, T} \tab vectors of covariates over rows (\code{X}) and columns 
  (\code{T}). \cr
 \code{M} \tab resulting matrix of smoothed values. \cr
 \code{R} \tab matrix of residuals of estimation, \eqn{Y - M}. \cr
 \code{h} \tab optimized or given bandwidths. \cr
 \code{c_f} \tab estimated variance coefficient. \cr
 \code{dcs_options} \tab an object of class \code{cds_options} containing the
  initial options of the dcs procedure. \cr
 \code{iterations} \tab number of iterations of the IPI-procedure. \cr
 \code{time_used} \tab time spend searching for optimal bandwidths (not
  overall runtime of the function). \cr
 \code{qarma} \tab optional return, if method \code{"qarma"} is chosen for 
  estimation of the variance factor. Omitted, if \code{"iid"} is used. \cr
 \code{dcs_options} \tab an object of class \code{cds_options} containing the
  initial options of the dcs procedure. \cr
}
}
\description{
\code{DCSmooth} provides a double conditional nonparametric smoothing of the
expectation surface of a functional time series or a random field on a
lattice. Bandwidth selection is done via an iterative plug-in method.
}
\section{Details}{

See the vignette for a more detailed description of the function.
}

\examples{
# See vignette("DCSmooth") for examples and explanation

y <- y.norm1 + matrix(rnorm(101^2), nrow = 101, ncol = 101)
dcs(y)

}
\seealso{
\code{\link{set.options}}
}
