% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_cluster_uv.R
\name{dcem_cluster_uv}
\alias{dcem_cluster_uv}
\title{dcem_cluster_uv (univariate data): Part of DCEM package.}
\usage{
dcem_cluster_uv(data, meu, sigma, prior, num_clusters, iteration_count,
threshold, num_data, numcols)
}
\arguments{
\item{data}{(matrix): The dataset provided by the user (converted to matrix format).}

\item{meu}{(vector): The vector containing the initial meu.}

\item{sigma}{(vector): The vector containing the initial standard deviation.}

\item{prior}{(vector): The vector containing the initial prior.}

\item{num_clusters}{(numeric): The number of clusters specified by the user. Default is 2.}

\item{iteration_count}{(numeric): The number of iterations for which the algorithm should run. If the
convergence is not achieved then the algorithm stops.
Default: 200.}

\item{threshold}{(numeric): A small value to check for convergence (if the estimated meu(s)
are within the threshold then the algorithm stops).

\strong{Note: Choosing a very small value (0.0000001) for threshold can increase the runtime
substantially and the algorithm may not converge. On the other hand, choosing a larger
value (0.1) can lead to sub-optimal clustering. Default: 0.00001}.}

\item{num_data}{(numeric): The total number of observations in the data.}

\item{numcols}{(numeric): Number of columns in the dataset (After processing the
missing values).}
}
\value{
A list of objects. This list contains parameters associated with the
        Gaussian(s) (posterior probabilities, meu, standard-deviation and prior)

\enumerate{
        \item (1) Posterior Probabilities: \strong{prob}: A matrix of
        posterior-probabilities.

        \item (2) Meu(s): \strong{meu}: It is a vector of
        meu. Each element of the vector corresponds to one meu.

        \item (3) Sigma: Standard-deviation(s): \strong{sigma}: A vector of standard
        deviation.

        \item (4) prior: \strong{prior}: A vector of prior.

        \item (5) Membership: \strong{membership}: A vector of
        cluster membership for data.
        }
}
\description{
Implements the Expectation Maximization algorithm for the univariate data. This function is internally
called by the dcem_train routine.
}
\references{
Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic

This work is partially supported by NCI Grant 1R01CA213466-01.
}
