% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{yeo.johnson}
\alias{yeo.johnson}
\title{Yeo-Johnson Transformation}
\usage{
yeo.johnson(
  y,
  lambda,
  derivative = 0,
  epsilon = sqrt(.Machine$double.eps),
  inverse = FALSE
)
}
\arguments{
\item{y}{Numeric, a vector or matrix.}

\item{lambda}{Numeric. It is recycled to the same length as \code{y} 
if necessary.}

\item{derivative}{Non-negative integer. The default is the ordinary function 
evaluation, otherwise the derivative with respect to \code{lambda}.}

\item{epsilon}{Numeric and positive value. The tolerance given to values of 
\code{lambda} when comparing it to 0 or 2.}

\item{inverse}{Logical. Return the inverse transformation?}
}
\value{
A vector of transformed values.
}
\description{
Computes the normalizing Yeo-Johnson transformation. #' This code and the details of the help file were taken from the \code{VGAM} package.
}
\details{
The Yeo-Johnson transformation can be thought of as an extension 
of the Box-Cox transformation. It handles both positive and negative values, 
whereas the Box-Cox transformation only handles positive values. Both can be 
used to transform the data so as to improve normality. They can be used to 
perform LMS quantile regression.
}
\author{
Thomas Yee
}
