% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_rates.R
\name{calc_Abeta}
\alias{calc_Abeta}
\title{Calculates the area at a point in time from a beta function}
\usage{
calc_Abeta(proptime, proptime_max, peak, Amax)
}
\arguments{
\item{proptime}{A numeric from 0 to 1. The proportion of time that has
elapsed in the simulation, in relation to the total island age (NB: not
the simulation time, but island age).}

\item{proptime_max}{A numeric from 0 to 1. The same as
\code{proportional_peak_t}. Indicates, in proportion to the total island
age when the ontogeny peak should occur (i.e. 0.5 means a peak halfway in
time).}

\item{peak}{A numeric value specifying the peakiness (or shaprness) of the
ontogeny curve. Higher values imply peakier ontogeny. This value is
internally calculated by \code{\link{calc_peak}()} given the area at the
present and the \code{area_pars}.}

\item{Amax}{A numeric value for maximum island area during the simulation.}
}
\value{
Numeric
}
\description{
Calculates the area at a point in time from a beta function
}
\author{
Joshua Lambert, Pedro Neves, Shu Xie
}
\keyword{internal}
