% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_sim_core_1_4.R
\name{DAISIE_calc_clade_clado_rate}
\alias{DAISIE_calc_clade_clado_rate}
\title{Calculate the clade-wide cladogenesis rate.}
\usage{
DAISIE_calc_clade_clado_rate(ps_clado_rate, n_species, carr_cap)
}
\arguments{
\item{ps_clado_rate}{per species cladogenesis rate}

\item{n_species}{number of species in that clade}

\item{carr_cap}{carrying capacity, number of species this clade will
grow to}
}
\value{
the clade's cladogenesis rate, which is at least zero. This
  rate will be zero if there are more species than the carrying capacity
  allows for
}
\description{
Calculate the clade-wide cladogenesis rate.
}
\note{
For clade-specific carrying capacity,
  each clade is simulated seperately in \code{\link{DAISIE_sim}}
}
\examples{
  testit::assert(
    DAISIE:::DAISIE_calc_clade_clado_rate(
      ps_clado_rate = 0.2,
      n_species = 5,
      carr_cap = 10
    ) == 0.5
  )
  testit::assert(
    DAISIE:::DAISIE_calc_clade_clado_rate(
      ps_clado_rate = 0.2,
      n_species = 2,
      carr_cap = 1
    ) == 0.0
  )
}
\author{
Richel J.C. Bilderbeek
}
\keyword{internal}
