% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_ML_IW.R
\name{DAISIE_ML_IW}
\alias{DAISIE_ML_IW}
\title{Maximization of the loglikelihood under the DAISIE model with island-wide
diversity-dependence}
\usage{
DAISIE_ML_IW(
  datalist,
  initparsopt,
  idparsopt,
  parsfix,
  idparsfix,
  res = 100,
  ddmodel = 11,
  cond = 0,
  tol = c(1e-04, 1e-05, 1e-07),
  maxiter = 1000 * round((1.25)^length(idparsopt)),
  methode = "ode45",
  optimmethod = "subplex",
  verbose = 0,
  tolint = c(1e-16, 1e-14),
  jitter = 0
)
}
\arguments{
\item{datalist}{Data object containing information on colonisation and
branching times. This object can be generated using the DAISIE_dataprep
function, which converts a user-specified data table into a data object,
but the object can of course also be entered directly.
It is an R list object with the following elements.\cr The first element
of the list has two or three components: \cr \cr \code{$island_age} - the
island age \cr Then, depending on whether a distinction between types is
made, we have:\cr \code{$not_present} - the number of mainland lineages
that are not present on the island \cr or:\cr \code{$not_present_type1} -
the number of mainland lineages of type 1 that are not present on the
island \cr \code{$not_present_type2} - the number of mainland lineages of
type 2 that are not present on the island \cr \cr The remaining elements of
the list each contains information on a single colonist lineage on the
island and has 5 components:\cr \cr \code{$colonist_name} - the name of the
species or clade that colonized the island \cr \code{$branching_times} -
island age followed by stem age of the population/species in the case of
Non-endemic, Non-endemic_MaxAge species and Endemic species with no close relatives
on the island. For endemic clades with more than one species on the island
(cladogenetic clades/ radiations) these should be island age followed by the
branching times of the island clade
including the stem age of the clade\cr \code{$stac} - the
status of the colonist \cr \cr * Non_endemic_MaxAge: 1 \cr * Endemic: 2
\cr * Endemic&Non_Endemic: 3 \cr * Non_Endemic: 4 \cr
* Endemic_Singleton_MaxAge: 5 \cr * Endemic_Clade_MaxAge: 6
\cr * Endemic&Non_Endemic_Clade_MaxAge: 7 \cr
\cr \code{$missing_species} - number of island species that were not
sampled for particular clade (only applicable for endemic clades) \cr
\code{$type1or2} - whether the colonist belongs to type 1 or type 2 \cr}

\item{initparsopt}{The initial values of the parameters that must be
optimized, they are all positive.}

\item{idparsopt}{The ids of the parameters that must be optimized. The ids
are defined as follows: \cr \cr id = 1 corresponds to lambda^c
(cladogenesis rate) \cr id = 2 corresponds to mu (extinction rate) \cr
id = 3 corresponds to K (clade-level carrying capacity) \cr id = 4
corresponds to gamma (immigration rate) \cr id = 5 corresponds to lambda^a
(anagenesis rate) \cr id = 6 corresponds to lambda^c (cladogenesis rate)
for an optional subset of the species \cr id = 7 corresponds to mu
(extinction rate) for an optional subset of the species\cr id = 8
corresponds to K (clade-level carrying capacity) for an optional subset of
the species\cr id = 9 corresponds to gamma (immigration rate) for an
optional subset of the species\cr id = 10 corresponds to lambda^a
(anagenesis rate) for an optional subset of the species\cr id = 11
corresponds to p_f (fraction of mainland species that belongs to the second
subset of species.}

\item{parsfix}{The values of the parameters that should not be optimized.}

\item{idparsfix}{The ids of the parameters that should not be optimized,
e.g. c(1,3) if lambda^c and K should not be optimized.}

\item{res}{Sets the maximum number of species for which a probability must
be computed, must be larger than the size of the largest clade.}

\item{ddmodel}{Sets the model of diversity-dependence: \cr \cr ddmodel = 0 :
no diversity dependence \cr ddmodel = 1 : linear dependence in speciation
rate \cr ddmodel = 11: linear dependence in speciation rate and in
immigration rate \cr ddmodel = 2 : exponential dependence in speciation
rate\cr ddmodel = 21: exponential dependence in speciation rate and in
immigration rate\cr}

\item{cond}{cond = 0 : conditioning on island age \cr cond = 1 :
conditioning on island age and non-extinction of the island biota \cr.}

\item{tol}{Sets the tolerances in the optimization. Consists of: \cr reltolx
= relative tolerance of parameter values in optimization \cr reltolf =
relative tolerance of function value in optimization \cr abstolx = absolute
tolerance of parameter values in optimization.}

\item{maxiter}{Sets the maximum number of iterations in the optimization.}

\item{methode}{Method of the ODE-solver. See package deSolve for details.
Default is "lsodes".}

\item{optimmethod}{Method used in likelihood optimization. Default is
"subplex" (see subplex package). Alternative is 'simplex' which was the
method in previous versions.}

\item{verbose}{In simulation and dataprep functions a logical,
\code{Default = TRUE} gives intermediate output should be printed.
For ML functions a numeric determining if intermediate output should be
printed, \code{Default = 0} does not print, \code{verbose = 1} prints
intermediate output of the parameters and loglikelihood, \code{verbose = 2}
means also intermediate progress during loglikelihood computation is shown.}

\item{tolint}{Vector of two elements containing the absolute and relative
tolerance of the integration.}

\item{jitter}{Numeric for \code{\link[DDD]{optimizer}()}. Jitters the
parameters being optimized by the specified amount which should be very
small, e.g. 1e-5. Jitter when \code{link[subplex]{subplex}()} produces
incorrect output due to parameter transformation.}
}
\value{
The output is a dataframe containing estimated parameters and
maximum loglikelihood.  \item{lambda_c}{ gives the maximum likelihood
estimate of lambda^c, the rate of cladogenesis} \item{mu}{ gives the maximum
likelihood estimate of mu, the extinction rate} \item{K}{ gives the maximum
likelihood estimate of K, the carrying-capacity} \item{gamma}{ gives the
maximum likelihood estimate of gamma, the immigration rate }
\item{lambda_a}{ gives the maximum likelihood estimate of lambda^a, the rate
of anagenesis} \item{loglik}{ gives the maximum loglikelihood} \item{df}{
gives the number of estimated parameters, i.e. degrees of feedom}
\item{conv}{ gives a message on convergence of optimization; conv = 0 means
convergence}
}
\description{
This function computes the maximum likelihood estimates of the parameters of
the DAISIE model with island-wide diversity-dependence for data from
lineages colonizing an island. It also outputs the corresponding
loglikelihood that can be used in model comparisons.
}
\details{
The result of sort(c(idparsopt, idparsfix)) should be identical to c(1:5).
If not, an error is reported that the input is incoherent. The same happens
when the length of initparsopt is different from the length of idparsopt,
and the length of parsfix is different from the length of idparsfix.\cr
}
\references{
Valente, L.M., A.B. Phillimore and R.S. Etienne (2015).
Equilibrium and non-equilibrium dynamics simultaneously operate in the
Galapagos islands. Ecology Letters 18: 844-852. <DOI:10.1111/ele.12461>.
}
\seealso{
\code{\link{DAISIE_loglik_IW}}, \code{\link{DAISIE_ML_CS}}
\code{\link{DAISIE_sim_constant_rate}}
}
\author{
Rampal S. Etienne
}
\keyword{models}
